/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.clients;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.bayonet.Bayonet;
import io.bayonet.exceptions.BayonetException;
import io.bayonet.helpers.HttpHelper;
import io.bayonet.model.device_fingerprint.DeviceFingerprintRequest;
import io.bayonet.model.device_fingerprint.ErrorResponse;
import java.util.HashMap;

public class DeviceFingerprintClient
extends Bayonet {
    private Integer http_response_code;
    private Integer reason_code;
    private String reason_message;
    private String bayonet_fingerprint;
    private HashMap<String, Object> device_info;

    public DeviceFingerprintClient(String api_key, String api_version) {
        super(api_key, api_version);
    }

    public void queryFingerprintData(DeviceFingerprintRequest params) throws BayonetException {
        this.validateClientConfig();
        if (params == null) {
            throw new BayonetException(-1, "params sent to the post request cannot be null", -1);
        }
        this.resetClass();
        params.setApiKey(this.api_key);
        HttpHelper http_helper = new HttpHelper();
        http_helper.request(params, "get-device-data", this.api_version);
        this.http_response_code = http_helper.getResponseCode();
        String response_json = http_helper.getResponseJson();
        if (response_json != null) {
            if (this.http_response_code == 200) {
                HashMap response_map;
                this.device_info = response_map = (HashMap)new Gson().fromJson(response_json, new TypeToken<HashMap<String, Object>>(){}.getType());
                this.reason_code = 0;
                this.reason_message = "success";
                if (response_map.containsKey("deviceFingerprint")) {
                    this.bayonet_fingerprint = response_map.get("deviceFingerprint").toString();
                }
            } else if (this.http_response_code == 400 || this.http_response_code == 500) {
                ErrorResponse error_response;
                try {
                    error_response = (ErrorResponse)new Gson().fromJson(response_json, ErrorResponse.class);
                }
                catch (JsonSyntaxException e) {
                    throw new BayonetException(-1, "Internal SDK error. The client could not parse Device fingerprinting API response correctly. Please contact the Bayonet team to report this bug", -1);
                }
                if (error_response.getReasonCode() == null) {
                    error_response.setReasonCode(-1);
                }
                if (error_response.getReasonMessage() == null) {
                    error_response.setReasonMessage("Could not fetch a response from the Bayonet API. Please try again after some time");
                }
                this.reason_code = error_response.getReasonCode();
                this.reason_message = error_response.getReasonMessage();
                throw new BayonetException(error_response.getReasonCode(), error_response.getReasonMessage(), this.http_response_code);
            }
        } else {
            throw new BayonetException(-1, "Could not fetch a response from the Bayonet API. Please try again after some time", -1);
        }
    }

    private void resetClass() {
        this.reason_code = null;
        this.reason_message = null;
        this.bayonet_fingerprint = null;
        this.device_info = null;
    }

    public Integer getHttpResponseCode() {
        return this.http_response_code;
    }

    public Integer getReasonCode() {
        return this.reason_code;
    }

    public String getReasonMessage() {
        return this.reason_message;
    }

    public String getBayonetFingerprint() {
        return this.bayonet_fingerprint;
    }

    public HashMap<String, Object> getDeviceInfo() {
        return this.device_info;
    }
}

