package io.bayonet.model.ecommerce;

import io.bayonet.model.base.Address;
import io.bayonet.model.base.AuthModel;
import io.bayonet.model.base.Product;

import java.util.ArrayList;

/**
 * Created by imranarshad on 11/28/17
 */

public class EcommerceFeedbackHistoricalRequest {


    /** Auth info of the client */

    private AuthModel auth;


    /** Consumer email */

    private String email;


    /** Consumer name as received by a client */

    private String consumer_name;


    /** Consumer ID used to identify this user in the client's internal system */

    private String consumer_internal_id;


    /** Name on the card being processed by the client */

    private String cardholder_name;


    /** Consumer phone number */

    private String telephone;


    /** Card being used for the payment */

    private String card_number;


    /** Bin number of the card being used - sent in case the client does not have the full card number */

    private String card_bin;


    /** Last 4 digits of the card being used - sent in case the client does not have the full card number */

    private String card_last_4;


    /** Amount of the transaction received by the client */

    private Double transaction_amount;


    /** Three letter ISO-4217 currency code */

    private String currency_code;


    /** Consumer shipping address */

    private Address shipping_address;


    /** Consumer billing address */

    private Address billing_address;


    /** Payment method being used on the client by the consumer */

    private String payment_method;


    /** Unix timestamp when the transaction occurred */

    private Long transaction_time;


    /** The coupon code used by the customer */

    private String coupon;


    /** Did the customer purchasing something choose the option to get expedited shipping - true or false */

    private Boolean expedited_shipping;


    /** The payment gateway used by the client for processing payments */

    private String payment_gateway;


    /** The channel through which the transaction is being made - ecommerce, pos or mpos */

    private String channel;


    /** The product that a customer is trying to buy on a client's site */

    private ArrayList<Product> products;


    /** Device fingerprint token generated by Bayonet's Device fingerprinting API */

    private String bayonet_fingerprint_token;
    

    /** What happened with the consumer transaction on the client - success, suspected_fraud or bank_decline */

    private String transaction_status;


    /** Code sent back by the processing bank to the client when a transaction is processed */

    private String bank_auth_code;


    /** Internal id of a transaction maintained by the client (and not by Bayonet or the processing bank in question) */

    private String transaction_id;


    /** Payment decline reason received by the client from the processing bank - should be sent when transaction_status = bank_decline */

    private String bank_decline_reason;


    /**
     * Getter and Setter methods
     */

    public void setApiKey(String api_key) {
        this.auth = new AuthModel(api_key);
    }

    public EcommerceFeedbackHistoricalRequest setEmail(String email) {
        this.email = email;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setConsumerName(String consumer_name) {
        this.consumer_name = consumer_name;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setConsumerInternalId(String consumer_internal_id) {
        this.consumer_internal_id = consumer_internal_id;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setCardholderName(String cardholder_name) {
        this.cardholder_name = cardholder_name;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setTelephone(String telephone) {
        this.telephone = telephone;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setCardNumber(String card_number) {
        this.card_number = card_number;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setCardBin(String card_bin) {
        this.card_bin = card_bin;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setCardLast4(String card_last_4) {
        this.card_last_4 = card_last_4;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setTransactionAmount(Double transaction_amount) {
        this.transaction_amount = transaction_amount;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setCurrencyCode(String currency_code) {
        this.currency_code = currency_code;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setShippingAddress(Address shipping_address) {
        this.shipping_address = shipping_address;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setBillingAddress(Address billing_address) {
        this.billing_address = billing_address;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setPaymentMethod(String payment_method) {
        this.payment_method = payment_method;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setTransactionTime(Long transaction_time) {
        this.transaction_time = transaction_time;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setCoupon(String coupon) {
        this.coupon = coupon;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setExpeditedShipping(Boolean expedited_shipping) {
        this.expedited_shipping = expedited_shipping;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setPaymentGateway(String payment_gateway) {
        this.payment_gateway = payment_gateway;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setProducts(ArrayList<Product> products) {
        this.products = products;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setBayonetFingerprintToken(String bayonet_fingerprint_token) {
        this.bayonet_fingerprint_token = bayonet_fingerprint_token;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setTransactionStatus(String transaction_status) {
        this.transaction_status = transaction_status;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setBankAuthCode(String bank_auth_code) {
        this.bank_auth_code = bank_auth_code;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setTransactionId(String transaction_id) {
        this.transaction_id = transaction_id;
        return this;
    }

    public EcommerceFeedbackHistoricalRequest setBankDeclineReason(String bank_decline_reason) {
        this.bank_decline_reason = bank_decline_reason;
        return this;
    }
}
