/*
 * Decompiled with CFR 0.152.
 */
package io.bayonet.helpers;

import io.bayonet.exceptions.BayonetException;
import java.util.Collection;
import java.util.HashSet;

public class DataHelper {
    public static void validateApiKey(String api_key) throws BayonetException {
        if (api_key == null || api_key.isEmpty()) {
            throw new BayonetException(-1, "Invalid client configuration. Please provide an Api key", -1);
        }
    }

    public static void validateApiVersion(String api_version, HashSet<String> supported_versions) throws BayonetException {
        if (api_version == null || api_version.isEmpty()) {
            throw new BayonetException(-1, "Please provide an Api version", -1);
        }
        if (!supported_versions.contains(api_version)) {
            throw new BayonetException(-1, "Invalid client configuration. This SDK does not support the API version specified. Supported versions are : " + DataHelper.getCommaSeparatedStringFromCollection(supported_versions), -1);
        }
    }

    private static String getCommaSeparatedStringFromCollection(Collection<String> collection) {
        if (collection == null || collection.size() == 0) {
            return "";
        }
        StringBuilder collection_string_builder = new StringBuilder();
        String comma = "";
        for (String temp : collection) {
            collection_string_builder.append(comma).append(temp);
            comma = ",";
        }
        return collection_string_builder.toString();
    }
}

