package io.bayonet.model.ecommerce;

import io.bayonet.model.base.Address;
import io.bayonet.model.base.AuthModel;
import io.bayonet.model.base.Product;

import java.util.ArrayList;

/**
 * Created by imranarshad on 11/27/17
 */

public class EcommerceConsultRequest {


    /** Auth info of the client */

    private AuthModel auth;


    /** Consumer email */

    private String email;


    /** Consumer name as received by a client */

    private String consumer_name;


    /** Consumer ID used to identify this user in the client's internal system */

    private String consumer_internal_id;


    /** Name on the card being processed by the client */

    private String cardholder_name;


    /** Consumer phone number */

    private String telephone;


    /** Card being used for the payment */

    private String card_number;


    /** Bin number of the card being used - sent in case the client does not have the full card number */

    private String card_bin;


    /** Last 4 digits of the card being used - sent in case the client does not have the full card number */

    private String card_last_4;


    /** Amount of the transaction received by the client */

    private Double transaction_amount;


    /** Three letter ISO-4217 currency code */

    private String currency_code;


    /** Consumer shipping address */

    private Address shipping_address;


    /** Consumer billing address */

    private Address billing_address;


    /** Payment method being used on the client by the consumer */

    private String payment_method;


    /** The coupon code used by the customer */

    private String coupon;


    /** Did the customer purchasing something choose the option to get expedited shipping - true or false */

    private Boolean expedited_shipping;


    /** The payment gateway used by the client for processing payments */

    private String payment_gateway;


    /** The channel through which the transaction is being made - ecommerce, pos or mpos */

    private String channel;


    /** The product that a customer is trying to buy on a client's site */

    private ArrayList<Product> products;


    /** Device fingerprint token generated by Bayonet's Device fingerprinting API */

    private String bayonet_fingerprint_token;


    /** Internal id of a transaction maintained by the client */

    private String transaction_id;


    /** Internal id of an order maintained by the client */

    private String order_id;


    /**
     * Getter and Setter methods
     */

    public void setApiKey(String api_key) {
        this.auth = new AuthModel(api_key);
    }

    public EcommerceConsultRequest setEmail(String email) {
        this.email = email;
        return this;
    }

    public EcommerceConsultRequest setConsumerName(String consumer_name) {
        this.consumer_name = consumer_name;
        return this;
    }

    public EcommerceConsultRequest setConsumerInternalId(String consumer_internal_id) {
        this.consumer_internal_id = consumer_internal_id;
        return this;
    }

    public EcommerceConsultRequest setCardholderName(String cardholder_name) {
        this.cardholder_name = cardholder_name;
        return this;
    }

    public EcommerceConsultRequest setTelephone(String telephone) {
        this.telephone = telephone;
        return this;
    }

    public EcommerceConsultRequest setCardNumber(String card_number) {
        this.card_number = card_number;
        return this;
    }

    public EcommerceConsultRequest setCardBin(String card_bin) {
        this.card_bin = card_bin;
        return this;
    }

    public EcommerceConsultRequest setCardLast4(String card_last_4) {
        this.card_last_4 = card_last_4;
        return this;
    }

    public EcommerceConsultRequest setTransactionAmount(Double transaction_amount) {
        this.transaction_amount = transaction_amount;
        return this;
    }

    public EcommerceConsultRequest setCurrencyCode(String currency_code) {
        this.currency_code = currency_code;
        return this;
    }

    public EcommerceConsultRequest setShippingAddress(Address shipping_address) {
        this.shipping_address = shipping_address;
        return this;
    }

    public EcommerceConsultRequest setBillingAddress(Address billing_address) {
        this.billing_address = billing_address;
        return this;
    }

    public EcommerceConsultRequest setPaymentMethod(String payment_method) {
        this.payment_method = payment_method;
        return this;
    }

    public EcommerceConsultRequest setCoupon(String coupon) {
        this.coupon = coupon;
        return this;
    }

    public EcommerceConsultRequest setExpeditedShipping(Boolean expedited_shipping) {
        this.expedited_shipping = expedited_shipping;
        return this;
    }

    public EcommerceConsultRequest setPaymentGateway(String payment_gateway) {
        this.payment_gateway = payment_gateway;
        return this;
    }

    public EcommerceConsultRequest setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public EcommerceConsultRequest setProducts(ArrayList<Product> products) {
        this.products = products;
        return this;
    }

    public EcommerceConsultRequest setBayonetFingerprintToken(String bayonet_fingerprint_token) {
        this.bayonet_fingerprint_token = bayonet_fingerprint_token;
        return this;
    }

    public EcommerceConsultRequest setTransactionId(String transaction_id) {
        this.transaction_id = transaction_id;
        return this;
    }

    public EcommerceConsultRequest setOrderId(String order_id) {
        this.order_id = order_id;
        return this;
    }
}
