/*
 * Decompiled with CFR 0.152.
 */
package io.backpackcloud.kodo;

import io.backpackcloud.kodo.Spec;
import io.backpackcloud.kodo.SpecDefinition;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hamcrest.Matcher;

public class Expectation {
    private final Function<Predicate, Predicate> modifier;

    private Expectation(Function<Predicate, Predicate> modifier) {
        this.modifier = modifier;
    }

    private <T> Predicate<T> create(Predicate<T> predicate) {
        return this.modifier.apply(predicate);
    }

    public <T> Predicate<T> be(T value) {
        return this.create(obj -> Objects.equals(obj, value));
    }

    public <T> Predicate<T> beNull() {
        return this.create(Objects::isNull);
    }

    public <T> Predicate<T> beNull(Class<T> type) {
        return this.create(Objects::isNull);
    }

    public <T> Predicate<T> eq(T value) {
        return this.be(value);
    }

    public <T> Predicate<T> be(Predicate<T> predicate) {
        return this.create(predicate);
    }

    public <T> Predicate<T> have(Predicate<T> predicate) {
        return this.create(predicate);
    }

    public <T> Predicate<T> match(Matcher matcher) {
        return this.create(arg_0 -> ((Matcher)matcher).matches(arg_0));
    }

    public Predicate<Exception> raise(Class<? extends Exception> exception) {
        return this.create(error -> error != null && exception.isAssignableFrom(error.getClass()));
    }

    public Predicate<Exception> succeed() {
        return this.create(Objects::isNull);
    }

    public Predicate<Exception> fail() {
        return this.not(this.succeed());
    }

    public <T> Predicate<T> follow(Consumer<SpecDefinition<T>> definition) {
        return t -> {
            definition.accept(Spec.given(t));
            return true;
        };
    }

    public Expectation not() {
        return new Expectation(Predicate::negate);
    }

    public <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static Expectation to() {
        return new Expectation(Function.identity());
    }

    public static <T> Predicate<T> to(Predicate<T> predicate) {
        return predicate;
    }

    public static <T> Consumer<T> doing(Function<T, ?> function) {
        return function::apply;
    }

    public static <T> Function<T, T> it() {
        return Function.identity();
    }

    public static <E> Supplier<E> the(E value) {
        return () -> value;
    }

    public static <T> Consumer<T> otherwise(Consumer<T> consumer) {
        return consumer;
    }

    public static <T> Consumer<T> because(String reason) {
        return obj -> {
            throw new AssertionError((Object)reason);
        };
    }

    public static Consumer throwAssertionError(String format) {
        return object -> {
            throw new AssertionError((Object)String.format(format, object));
        };
    }

    public static Consumer throwAssertionError() {
        return Expectation.throwAssertionError("for value: %s");
    }
}

