/*
 * Decompiled with CFR 0.152.
 */
package io.backpackcloud.kodo;

import io.backpackcloud.kodo.Expectation;
import io.backpackcloud.kodo.SpecDefinition;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DefaultSpecDefinition<T>
implements SpecDefinition<T> {
    final String description;
    final T target;
    final Consumer defaultFailOperation;

    DefaultSpecDefinition(String description, T target, Consumer<?> defaultFailOperation) {
        this.description = description;
        this.target = target;
        this.defaultFailOperation = defaultFailOperation;
    }

    DefaultSpecDefinition(T target) {
        this("", target, Expectation.throwAssertionError());
    }

    DefaultSpecDefinition(String description) {
        this(description, null, Expectation.throwAssertionError());
    }

    DefaultSpecDefinition() {
        this("", null, Expectation.throwAssertionError());
    }

    private void test(Predicate predicate, Object object, Consumer consumer) {
        if (!predicate.test(object)) {
            consumer.accept(object);
        }
    }

    @Override
    public SpecDefinition<T> onFail(Consumer<?> operation) {
        return new DefaultSpecDefinition<T>(this.description, this.target, operation);
    }

    @Override
    public <R> SpecDefinition<R> given(R object) {
        return new DefaultSpecDefinition<R>(this.description, object, this.defaultFailOperation);
    }

    @Override
    public <R> SpecDefinition<R> given(Function<T, R> function) {
        return new DefaultSpecDefinition<R>(this.description, function.apply(this.target), this.defaultFailOperation);
    }

    @Override
    public SpecDefinition begin() {
        return new DefaultSpecDefinition<T>(this.description);
    }

    @Override
    public SpecDefinition<T> when(Consumer<? super T> operation) {
        operation.accept(this.target);
        return this;
    }

    @Override
    public SpecDefinition<T> expect(Consumer operation, Predicate test, Consumer consumer) {
        try {
            operation.accept(this.target);
            this.test(test, null, consumer);
        }
        catch (Exception e) {
            this.test(test, e, consumer);
        }
        return this;
    }

    @Override
    public SpecDefinition<T> when(Runnable operation) {
        operation.run();
        return this;
    }

    @Override
    public <E> SpecDefinition<T> expect(Function<? super T, E> function, Predicate<? super E> test, Consumer<E> consumer) {
        this.test(test, function.apply(this.target), consumer);
        return this;
    }

    @Override
    public <E> SpecDefinition<T> expect(Supplier<E> supplier, Predicate<? super E> test) {
        return this.expect(supplier, test, this.defaultFailOperation);
    }

    @Override
    public <E> SpecDefinition<T> expect(Supplier<E> supplier, Predicate<? super E> test, Consumer<E> consumer) {
        this.test(test, supplier.get(), consumer);
        return this;
    }

    @Override
    public SpecDefinition<T> expect(Function<? super T, Boolean> function, Consumer<Boolean> consumer) {
        this.test(o -> o == Boolean.TRUE, function.apply(this.target), consumer);
        return this;
    }

    @Override
    public SpecDefinition<T> expect(boolean value, Consumer<Boolean> consumer) {
        this.test(o -> o == Boolean.TRUE, value, consumer);
        return this;
    }

    @Override
    public <E> SpecDefinition<T> each(Class<E> type, Function<T, Iterable<E>> splitter, Consumer<SpecDefinition<E>> spec) {
        splitter.apply(this.target).forEach(e -> spec.accept(new DefaultSpecDefinition<Object>(this.description, e, this.defaultFailOperation)));
        return this;
    }

    @Override
    public SpecDefinition<T> expect(Consumer<? super T> operation, Predicate<? extends Exception> test) {
        return this.expect((Consumer)operation, (Predicate)test, this.defaultFailOperation);
    }

    @Override
    public <E> SpecDefinition<T> expect(Function<? super T, E> function, Predicate<? super E> test) {
        return this.expect(function, test, this.defaultFailOperation);
    }

    @Override
    public SpecDefinition<T> expect(Function<? super T, Boolean> function) {
        return this.expect(function, (Consumer<Boolean>)this.defaultFailOperation);
    }

    @Override
    public SpecDefinition<T> expect(boolean value) {
        return this.expect(value, (Consumer<Boolean>)this.defaultFailOperation);
    }
}

