/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.jdsl;

import io.atomicbits.scraml.jdsl.BinaryRequest;
import io.atomicbits.scraml.jdsl.BodyPart;
import io.atomicbits.scraml.jdsl.HttpParam;
import io.atomicbits.scraml.jdsl.Method;
import io.atomicbits.scraml.jdsl.RequestBuilder;
import io.atomicbits.scraml.jdsl.Response;
import io.atomicbits.scraml.jdsl.Segment;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public abstract class MethodSegment<B, R>
extends Segment {
    private B body;
    private RequestBuilder requestBuilder;

    protected MethodSegment(Method method, B b, Map<String, HttpParam> map, Map<String, HttpParam> map2, List<BodyPart> list, BinaryRequest binaryRequest, String string, String string2, RequestBuilder requestBuilder) {
        this.body = b;
        RequestBuilder requestBuilder2 = requestBuilder.fold();
        requestBuilder2.setMethod(method);
        requestBuilder2.setQueryParameters(this.removeNullParams(map));
        requestBuilder2.setFormParameters(this.removeNullParams(map2));
        requestBuilder2.setMultipartParams(list);
        requestBuilder2.setBinaryRequest(binaryRequest);
        String string3 = "Accept";
        String string4 = "Content-Type";
        if (string != null && !requestBuilder2.getHeaderMap().hasKey(string3)) {
            requestBuilder2.getHeaderMap().addHeader(string3, string);
        }
        if (string2 != null && !requestBuilder2.getHeaderMap().hasKey(string4)) {
            requestBuilder2.getHeaderMap().addHeader(string4, string2);
        }
        this.setRequestCharset(requestBuilder2, string4);
        this.requestBuilder = requestBuilder2;
    }

    protected Future<Response<String>> callToStringResponse(String string) {
        return this.requestBuilder.callToStringResponse(this.getBody(), string);
    }

    protected Future<Response<R>> callToTypeResponse(String string, String string2) {
        return this.requestBuilder.callToTypeResponse(this.getBody(), string, string2);
    }

    protected B getBody() {
        return this.body;
    }

    @Override
    protected RequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    private void setRequestCharset(RequestBuilder requestBuilder, String string) {
        if (requestBuilder.getHeaderMap().hasKey(string)) {
            String string2;
            List<String> list = requestBuilder.getHeaderMap().getValues(string);
            Boolean bl = false;
            Boolean bl2 = false;
            Object object = list.iterator();
            while (object.hasNext()) {
                string2 = object.next();
                if (string2.toLowerCase().contains("charset")) {
                    bl = true;
                }
                if (!string2.toLowerCase().contains("octet-stream")) continue;
                bl2 = true;
            }
            if (!(bl2.booleanValue() || bl.booleanValue() || list.isEmpty() || (object = requestBuilder.getClient().getConfig().getRequestCharset()) == null)) {
                string2 = list.get(0);
                String string3 = string2 + "; charset=" + ((Charset)object).name();
                list.set(0, string3);
                requestBuilder.getHeaderMap().setHeader(string, list);
            }
        }
    }

    private Map<String, HttpParam> removeNullParams(Map<String, HttpParam> map) {
        HashMap<String, HttpParam> hashMap = new HashMap<String, HttpParam>();
        if (map != null) {
            for (String string : map.keySet()) {
                HttpParam httpParam = map.get(string);
                if (httpParam == null) continue;
                hashMap.put(string, httpParam);
            }
        }
        return hashMap;
    }
}

