/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.jdsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HeaderMap {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Map<String, String> originalKeys = new HashMap<String, String>();

    public void addHeader(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        this.addHeader(string, arrayList);
    }

    public void addHeader(String string, List<String> list) {
        if (string == null || list == null) {
            return;
        }
        String string2 = string.trim();
        String string3 = this.normalizeKey(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : list) {
            if (string4 == null) continue;
            arrayList.add(string4.trim());
        }
        if (string2.isEmpty() || arrayList.isEmpty()) {
            return;
        }
        this.originalKeys.put(string3, string2);
        ArrayList arrayList2 = this.headers.get(string3);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
            this.headers.put(string3, arrayList2);
        }
        arrayList2.addAll(arrayList);
    }

    public void addHeaders(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public void addHeaders(HeaderMap headerMap) {
        for (Map.Entry<String, List<String>> entry : headerMap.getHeaders().entrySet()) {
            for (String string : entry.getValue()) {
                this.addHeader(entry.getKey(), string);
            }
        }
    }

    public void setHeader(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.setHeader(string, arrayList);
    }

    void setHeader(String string, List<String> list) {
        if (string == null || list == null) {
            return;
        }
        String string2 = string.trim();
        String string3 = this.normalizeKey(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : list) {
            if (string4 == null) continue;
            arrayList.add(string4.trim());
        }
        if (string2.isEmpty() || arrayList.isEmpty()) {
            return;
        }
        this.originalKeys.put(string3, string2);
        this.headers.put(string3, arrayList);
    }

    public void setHeaders(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public void setHeaders(HeaderMap headerMap) {
        for (Map.Entry<String, List<String>> entry : headerMap.getHeaders().entrySet()) {
            this.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            hashMap.put(this.originalKeys.get(entry.getKey()), entry.getValue());
        }
        return hashMap;
    }

    public HeaderMap cloned() {
        HeaderMap headerMap = new HeaderMap();
        headerMap.headers = this.cloneHeaders();
        headerMap.originalKeys = this.cloneOriginalKeys();
        return headerMap;
    }

    public boolean hasKey(String string) {
        if (string == null) {
            return false;
        }
        String string2 = this.normalizeKey(string);
        return this.originalKeys.get(string2) != null;
    }

    public List<String> getValues(String string) {
        if (string == null) {
            return new ArrayList<String>();
        }
        String string2 = this.normalizeKey(string);
        List<String> list = this.headers.get(string2);
        if (list != null) {
            return list;
        }
        return new ArrayList<String>();
    }

    private <T> List<T> cloneList(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (T t : list) {
            arrayList.add(t);
        }
        return arrayList;
    }

    private Map<String, String> cloneOriginalKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.originalKeys);
        return hashMap;
    }

    private Map<String, List<String>> cloneHeaders() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            hashMap.put(entry.getKey(), this.cloneList(entry.getValue()));
        }
        return hashMap;
    }

    private String normalizeKey(String string) {
        String string2 = string.trim();
        return string2.toLowerCase(Locale.ENGLISH);
    }
}

