/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.jdsl.client.ning;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.Part;
import io.atomicbits.scraml.jdsl.BinaryData;
import io.atomicbits.scraml.jdsl.BinaryRequest;
import io.atomicbits.scraml.jdsl.BodyPart;
import io.atomicbits.scraml.jdsl.ByteArrayBinaryRequest;
import io.atomicbits.scraml.jdsl.ByteArrayPart;
import io.atomicbits.scraml.jdsl.Client;
import io.atomicbits.scraml.jdsl.FileBinaryRequest;
import io.atomicbits.scraml.jdsl.FilePart;
import io.atomicbits.scraml.jdsl.HeaderMap;
import io.atomicbits.scraml.jdsl.HttpParam;
import io.atomicbits.scraml.jdsl.InputStreamBinaryRequest;
import io.atomicbits.scraml.jdsl.RepeatedHttpParam;
import io.atomicbits.scraml.jdsl.RequestBuilder;
import io.atomicbits.scraml.jdsl.Response;
import io.atomicbits.scraml.jdsl.SingleHttpParam;
import io.atomicbits.scraml.jdsl.StringBinaryRequest;
import io.atomicbits.scraml.jdsl.StringPart;
import io.atomicbits.scraml.jdsl.client.ClientConfig;
import io.atomicbits.scraml.jdsl.client.ning.Ning19BinaryData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ning19Client
implements Client {
    private String protocol;
    private String host;
    private int port;
    private String prefix;
    private ClientConfig config;
    private Map<String, String> defaultHeaders;
    private AsyncHttpClient ningClient;
    private Logger LOGGER = LoggerFactory.getLogger(Ning19Client.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    public Ning19Client(String string, Integer n, String string2, String string3, ClientConfig clientConfig, Map<String, String> map) {
        this.host = string != null ? string : "localhost";
        this.port = n != null ? n : 80;
        this.protocol = string2 != null ? string2 : "http";
        this.prefix = string3;
        this.config = clientConfig != null ? clientConfig : new ClientConfig();
        this.defaultHeaders = map != null ? map : new HashMap<String, String>();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        this.ningClient = new AsyncHttpClient(this.applyConfiguration(builder).build());
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public String getCleanPrefix() {
        if (this.prefix != null) {
            String string = this.prefix;
            if (this.prefix.startsWith("/")) {
                string = string.substring(1);
            }
            if (this.prefix.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            return "/" + string;
        }
        return "";
    }

    private AsyncHttpClient getClient() {
        return this.ningClient;
    }

    private AsyncHttpClientConfig.Builder applyConfiguration(AsyncHttpClientConfig.Builder builder) {
        builder.setReadTimeout(this.config.getRequestTimeout());
        builder.setMaxConnections(this.config.getMaxConnections());
        builder.setRequestTimeout(this.config.getRequestTimeout());
        builder.setMaxRequestRetry(this.config.getMaxRequestRetry());
        builder.setConnectTimeout(this.config.getConnectTimeout());
        builder.setConnectionTTL(this.config.getConnectionTTL());
        builder.setWebSocketTimeout(this.config.getWebSocketTimeout());
        builder.setMaxConnectionsPerHost(this.config.getMaxConnectionsPerHost());
        builder.setAllowPoolingConnections(this.config.getAllowPoolingConnections().booleanValue());
        builder.setAllowPoolingSslConnections(this.config.getAllowPoolingSslConnections().booleanValue());
        builder.setPooledConnectionIdleTimeout(this.config.getPooledConnectionIdleTimeout());
        builder.setAcceptAnyCertificate(this.config.getAcceptAnyCertificate().booleanValue());
        builder.setFollowRedirect(this.config.getFollowRedirect().booleanValue());
        builder.setMaxRedirects(this.config.getMaxRedirects());
        builder.setStrict302Handling(this.config.getStrict302Handling().booleanValue());
        return builder;
    }

    @Override
    public <B> CompletableFuture<Response<String>> callToStringResponse(RequestBuilder requestBuilder, B b, String string) {
        return this.callToResponse(requestBuilder, b, string, this::transformToStringBody);
    }

    @Override
    public <B> CompletableFuture<Response<BinaryData>> callToBinaryResponse(RequestBuilder requestBuilder, B b, String string) {
        return this.callToResponse(requestBuilder, b, string, this::transformToBinaryBody);
    }

    @Override
    public <B, R> CompletableFuture<Response<R>> callToTypeResponse(RequestBuilder requestBuilder, B b, String string, String string2) {
        return this.callToResponse(requestBuilder, b, string, response -> this.transformToTypedBody((com.ning.http.client.Response)response, string2));
    }

    protected <B, R> CompletableFuture<Response<R>> callToResponse(RequestBuilder requestBuilder, B b, String string, final Function<com.ning.http.client.Response, Response<R>> function) {
        Object object;
        Object object2;
        com.ning.http.client.RequestBuilder requestBuilder2 = new com.ning.http.client.RequestBuilder();
        String string2 = this.protocol + "://" + this.host + ":" + this.port + this.getCleanPrefix();
        requestBuilder2.setUrl(string2 + "/" + requestBuilder.getRelativePath());
        requestBuilder2.setMethod(requestBuilder.getMethod().name());
        HeaderMap headerMap = new HeaderMap();
        headerMap.addHeaders(this.defaultHeaders);
        headerMap.addHeaders(requestBuilder.getHeaders());
        for (Map.Entry<String, List<String>> object32 : headerMap.getHeaders().entrySet()) {
            for (String string3 : object32.getValue()) {
                requestBuilder2.addHeader(object32.getKey(), string3);
            }
        }
        for (Map.Entry<String, Object> entry : requestBuilder.getQueryParameters().entrySet()) {
            if (((HttpParam)entry.getValue()).isSingle().booleanValue()) {
                object2 = (SingleHttpParam)entry.getValue();
                if (((SingleHttpParam)object2).getParameter() == null) continue;
                requestBuilder2.addQueryParam(entry.getKey(), ((SingleHttpParam)object2).getParameter());
                continue;
            }
            object2 = (RepeatedHttpParam)entry.getValue();
            if (((RepeatedHttpParam)object2).getParameters() == null) continue;
            for (String string4 : ((RepeatedHttpParam)object2).getParameters()) {
                requestBuilder2.addQueryParam(entry.getKey(), string4);
            }
        }
        if (b != null) {
            requestBuilder2.setBody(this.writeBodyToString(string, b));
        }
        if (requestBuilder.getBinaryRequest() != null) {
            object = requestBuilder.getBinaryRequest();
            if (((BinaryRequest)object).isFile()) {
                File file = ((FileBinaryRequest)object).getFile();
                requestBuilder2.setBody(file);
            }
            if (((BinaryRequest)object).isInputStream()) {
                InputStream inputStream = ((InputStreamBinaryRequest)object).getInputStream();
                requestBuilder2.setBody((BodyGenerator)new InputStreamBodyGenerator(inputStream));
            }
            if (((BinaryRequest)object).isByteArray()) {
                byte[] byArray = ((ByteArrayBinaryRequest)object).getBytes();
                requestBuilder2.setBody(byArray);
            }
            if (((BinaryRequest)object).isString()) {
                String string5 = ((StringBinaryRequest)object).getText();
                requestBuilder2.setBody(string5);
            }
        }
        for (Map.Entry<String, HttpParam> entry : requestBuilder.getFormParameters().entrySet()) {
            if (entry.getValue().isSingle().booleanValue()) {
                object2 = (SingleHttpParam)entry.getValue();
                if (((SingleHttpParam)object2).getParameter() == null) continue;
                requestBuilder2.addFormParam(entry.getKey(), ((SingleHttpParam)object2).getParameter());
                continue;
            }
            object2 = (RepeatedHttpParam)entry.getValue();
            if (((RepeatedHttpParam)object2).getParameters() == null) continue;
            for (String string4 : ((RepeatedHttpParam)object2).getParameters()) {
                requestBuilder2.addFormParam(entry.getKey(), string4);
            }
        }
        for (BodyPart bodyPart : requestBuilder.getMultipartParams()) {
            if (bodyPart.isString().booleanValue()) {
                object2 = (StringPart)bodyPart;
                requestBuilder2.addBodyPart((Part)new com.ning.http.client.multipart.StringPart(((StringPart)object2).getName(), ((StringPart)object2).getValue(), ((StringPart)object2).getContentType(), ((StringPart)object2).getCharset(), ((StringPart)object2).getContentId(), ((StringPart)object2).getTransferEncoding()));
            }
            if (bodyPart.isFile().booleanValue()) {
                object2 = (FilePart)bodyPart;
                requestBuilder2.addBodyPart((Part)new com.ning.http.client.multipart.FilePart(((FilePart)object2).getName(), ((FilePart)object2).getFile(), ((FilePart)object2).getContentType(), ((FilePart)object2).getCharset(), ((FilePart)object2).getFileName(), ((FilePart)object2).getContentId(), ((FilePart)object2).getTransferEncoding()));
            }
            if (!bodyPart.isByteArray().booleanValue()) continue;
            object2 = (ByteArrayPart)bodyPart;
            requestBuilder2.addBodyPart((Part)new com.ning.http.client.multipart.ByteArrayPart(((ByteArrayPart)object2).getName(), ((ByteArrayPart)object2).getBytes(), ((ByteArrayPart)object2).getContentType(), ((ByteArrayPart)object2).getCharset(), ((ByteArrayPart)object2).getFileName(), ((ByteArrayPart)object2).getContentId(), ((ByteArrayPart)object2).getTransferEncoding()));
        }
        object = requestBuilder2.build();
        final CompletableFuture<Response<R>> completableFuture = new CompletableFuture<Response<R>>();
        this.LOGGER.debug("Executing request: " + object + "\nWith 'string' body: " + object.getStringData());
        this.getClient().executeRequest(object, (AsyncHandler)new AsyncCompletionHandler<String>(){

            public String onCompleted(com.ning.http.client.Response response) throws Exception {
                try {
                    Response response2 = (Response)function.apply(response);
                    completableFuture.complete(response2);
                }
                catch (Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }
                return null;
            }

            public void onThrowable(Throwable throwable) {
                super.onThrowable(throwable);
                completableFuture.completeExceptionally(throwable);
            }
        });
        return completableFuture;
    }

    private Response<String> transformToStringBody(com.ning.http.client.Response response) {
        try {
            String string = response.getResponseBody(this.config.getResponseCharset().displayName());
            return new Response<String>(string, string, response.getStatusCode(), (Map<String, List<String>>)response.getHeaders());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private Response<BinaryData> transformToBinaryBody(com.ning.http.client.Response response) {
        try {
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                Ning19BinaryData ning19BinaryData = new Ning19BinaryData(response);
                return new Response<BinaryData>(null, ning19BinaryData, response.getStatusCode(), (Map<String, List<String>>)response.getHeaders());
            }
            String string = response.getResponseBody(this.config.getResponseCharset().displayName());
            return new Response<Object>(string, null, response.getStatusCode(), (Map<String, List<String>>)response.getHeaders());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private <R> Response<R> transformToTypedBody(com.ning.http.client.Response response, String string) {
        try {
            String string2 = response.getResponseBody(this.config.getResponseCharset().displayName());
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                return new Response<R>(string2, this.parseBodyToObject(string2, string), response.getStatusCode(), (Map<String, List<String>>)response.getHeaders());
            }
            return new Response<Object>(string2, null, response.getStatusCode(), (Map<String, List<String>>)response.getHeaders());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void close() {
        if (this.ningClient != null) {
            this.ningClient.close();
        }
    }

    private <B> String writeBodyToString(String string, B b) {
        if (string != null) {
            JavaType javaType = TypeFactory.defaultInstance().constructFromCanonical(string);
            ObjectWriter objectWriter = this.objectMapper.writerFor(javaType);
            try {
                return objectWriter.writeValueAsString(b);
            }
            catch (IOException iOException) {
                throw new RuntimeException("JSON parse error: " + iOException.getMessage(), iOException);
            }
        }
        try {
            return this.objectMapper.writeValueAsString(b);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException("JSON parse error: " + jsonProcessingException.getMessage(), jsonProcessingException);
        }
    }

    private <R> R parseBodyToObject(String string, String string2) {
        JavaType javaType = TypeFactory.defaultInstance().constructFromCanonical(string2);
        try {
            return (R)this.objectMapper.readValue(string, javaType);
        }
        catch (IOException iOException) {
            throw new RuntimeException("JSON parse error: " + iOException.getMessage(), iOException);
        }
    }
}

