/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.jdsl;

import io.atomicbits.scraml.jdsl.BinaryRequest;
import io.atomicbits.scraml.jdsl.BodyPart;
import io.atomicbits.scraml.jdsl.HttpParam;
import io.atomicbits.scraml.jdsl.Method;
import io.atomicbits.scraml.jdsl.RequestBuilder;
import io.atomicbits.scraml.jdsl.Response;
import io.atomicbits.scraml.jdsl.Segment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public abstract class MethodSegment<B, R>
extends Segment {
    private B body;
    private RequestBuilder requestBuilder;

    protected MethodSegment(Method method, B b, Map<String, HttpParam> map, Map<String, HttpParam> map2, List<BodyPart> list, BinaryRequest binaryRequest, String string, String string2, RequestBuilder requestBuilder) {
        this.body = b;
        RequestBuilder requestBuilder2 = requestBuilder.fold();
        requestBuilder2.setMethod(method);
        requestBuilder2.setQueryParameters(this.removeNullParams(map));
        requestBuilder2.setFormParameters(this.removeNullParams(map2));
        requestBuilder2.setMultipartParams(list);
        requestBuilder2.setBinaryRequest(binaryRequest);
        if (string != null && !requestBuilder2.getHeaders().hasKey("Accept")) {
            requestBuilder2.addHeader("Accept", string);
        }
        if (string2 != null && !requestBuilder2.getHeaders().hasKey("Content-Type")) {
            requestBuilder2.addHeader("Content-Type", string2);
        }
        this.requestBuilder = requestBuilder2;
    }

    protected Future<Response<String>> callToStringResponse(String string) {
        return this.requestBuilder.callToStringResponse(this.getBody(), string);
    }

    protected Future<Response<R>> callToTypeResponse(String string, String string2) {
        return this.requestBuilder.callToTypeResponse(this.getBody(), string, string2);
    }

    protected B getBody() {
        return this.body;
    }

    @Override
    protected RequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    private Map<String, HttpParam> removeNullParams(Map<String, HttpParam> map) {
        HashMap<String, HttpParam> hashMap = new HashMap<String, HttpParam>();
        if (map != null) {
            for (String string : map.keySet()) {
                HttpParam httpParam = map.get(string);
                if (httpParam == null) continue;
                hashMap.put(string, httpParam);
            }
        }
        return hashMap;
    }
}

