/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.jdsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HeaderMap {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Map<String, String> originalKeys = new HashMap<String, String>();

    public void addHeader(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        String string3 = string.trim();
        String string4 = string3.toLowerCase(Locale.ENGLISH);
        String string5 = string2.trim();
        if (string3.isEmpty() || string5.isEmpty()) {
            return;
        }
        this.originalKeys.put(string4, string3);
        List<String> list = this.headers.get(string4);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(string4, list);
        }
        list.add(string5);
    }

    public void addHeaders(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public void addHeaders(HeaderMap headerMap) {
        for (Map.Entry<String, List<String>> entry : headerMap.getHeaders().entrySet()) {
            for (String string : entry.getValue()) {
                this.addHeader(entry.getKey(), string);
            }
        }
    }

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            hashMap.put(this.originalKeys.get(entry.getKey()), entry.getValue());
        }
        return hashMap;
    }

    public HeaderMap cloned() {
        HeaderMap headerMap = new HeaderMap();
        headerMap.headers = this.cloneHeaders();
        headerMap.originalKeys = this.cloneOriginalKeys();
        return headerMap;
    }

    public boolean hasKey(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return this.originalKeys.get(string2) != null;
    }

    private <T> List<T> cloneList(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (T t : list) {
            arrayList.add(t);
        }
        return arrayList;
    }

    private Map<String, String> cloneOriginalKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.originalKeys);
        return hashMap;
    }

    private Map<String, List<String>> cloneHeaders() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            hashMap.put(entry.getKey(), this.cloneList(entry.getValue()));
        }
        return hashMap;
    }
}

