/*
 * Decompiled with CFR 0.152.
 */
package io.atomicbits.scraml.dsl.java;

import io.atomicbits.scraml.dsl.java.BodyPart;
import io.atomicbits.scraml.dsl.java.Client;
import io.atomicbits.scraml.dsl.java.HeaderMap;
import io.atomicbits.scraml.dsl.java.HttpParam;
import io.atomicbits.scraml.dsl.java.Method;
import io.atomicbits.scraml.dsl.java.Response;
import io.atomicbits.scraml.dsl.java.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RequestBuilder {
    private Client client;
    private List<String> path = new ArrayList<String>();
    private Method method = Method.GET;
    private Map<String, HttpParam> queryParameters = new HashMap<String, HttpParam>();
    private Map<String, HttpParam> formParameters = new HashMap<String, HttpParam>();
    private List<BodyPart> multipartParams = new ArrayList<BodyPart>();
    private HeaderMap headers = new HeaderMap();
    List<RequestBuilder> childRequestBuilders = new ArrayList<RequestBuilder>();
    private boolean initialized;

    public RequestBuilder() {
    }

    public RequestBuilder(Client client) {
        this.client = client;
    }

    private RequestBuilder(Client client, List<String> list, Method method, Map<String, HttpParam> map, Map<String, HttpParam> map2, List<BodyPart> list2, HeaderMap headerMap) {
        this.setClient(client);
        this.setPath(list);
        this.setMethod(method);
        this.setQueryParameters(map);
        this.setFormParameters(map2);
        this.setMultipartParams(list2);
        this.setHeaders(headerMap);
    }

    public Client getClient() {
        return this.client;
    }

    public Map<String, HttpParam> getFormParameters() {
        return this.formParameters;
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public void addHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    public Method getMethod() {
        return this.method;
    }

    public List<BodyPart> getMultipartParams() {
        return this.multipartParams;
    }

    public Map<String, HttpParam> getQueryParameters() {
        return this.queryParameters;
    }

    public List<String> getPath() {
        return this.path;
    }

    public void setChildRequestBuilders(List<RequestBuilder> list) {
        this.childRequestBuilders = list;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setFormParameters(Map<String, HttpParam> map) {
        this.formParameters = map == null ? new HashMap<String, HttpParam>() : map;
    }

    public void setHeaders(HeaderMap headerMap) {
        this.headers = headerMap == null ? new HeaderMap() : headerMap;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setMultipartParams(List<BodyPart> list) {
        this.multipartParams = list == null ? new ArrayList<BodyPart>() : list;
    }

    public void setPath(List<String> list) {
        this.path = list == null ? new ArrayList<String>() : list;
    }

    public void setQueryParameters(Map<String, HttpParam> map) {
        this.queryParameters = map == null ? new HashMap<String, HttpParam>() : map;
    }

    public String getRelativePath() {
        return ListUtils.mkString(this.path, "/");
    }

    public void appendPathElement(String string) {
        this.path.add(string);
    }

    public void prependPathElements(List<String> list) {
        this.path.addAll(0, list);
    }

    public RequestBuilder cloneAddHeader(String string, String string2) {
        RequestBuilder requestBuilder = this.shallowClone();
        requestBuilder.headers = this.headers.cloned();
        requestBuilder.addHeader(string, string2);
        return requestBuilder;
    }

    public <B> CompletableFuture<Response<String>> callToStringResponse(B b, String string) {
        return this.client.callToStringResponse(this, b, string);
    }

    public <B, R> CompletableFuture<Response<R>> callToTypeResponse(B b, String string, String string2) {
        return this.client.callToTypeResponse(this, b, string, string2);
    }

    public RequestBuilder shallowClone() {
        RequestBuilder requestBuilder = new RequestBuilder(this.client, this.path, this.method, this.queryParameters, this.formParameters, this.multipartParams, this.headers);
        requestBuilder.childRequestBuilders = new ArrayList<RequestBuilder>(this.childRequestBuilders);
        return requestBuilder;
    }

    public void addChild(RequestBuilder requestBuilder) {
        this.childRequestBuilders.add(requestBuilder);
    }

    public void initializeChildren() {
        for (RequestBuilder requestBuilder : this.childRequestBuilders) {
            requestBuilder.initializeFromParent(this);
        }
    }

    protected void initializeFromParent(RequestBuilder requestBuilder) {
        if (this.isNotInitialized()) {
            this.client = requestBuilder.client;
            this.prependPathElements(requestBuilder.path);
            this.initializeChildren();
            this.setInitialized();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("client:\t\t" + this.client + "\n");
        stringBuilder.append("path:\t\t" + this.listToString(this.path) + "\n");
        for (RequestBuilder requestBuilder : this.childRequestBuilders) {
            stringBuilder.append(requestBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private String listToString(List list) {
        String string = "";
        for (Object e : list) {
            string = string + e.toString() + ", ";
        }
        return string;
    }

    public boolean isNotInitialized() {
        return !this.initialized;
    }

    private void setInitialized() {
        this.initialized = true;
    }
}

