/*
 * Decompiled with CFR 0.152.
 */
package io.ataraxic.nomicflux.voyageur.impl;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.adt.choice.Choice2;
import com.jnape.palatable.lambda.adt.hlist.HList;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.functions.builtin.fn1.Constantly;
import com.jnape.palatable.lambda.functions.builtin.fn2.Drop;
import com.jnape.palatable.lambda.functions.builtin.fn2.Zip;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.shoki.api.Set;
import com.jnape.palatable.shoki.impl.HashMap;
import com.jnape.palatable.shoki.impl.HashSet;
import io.ataraxic.nomicflux.voyageur.Context;
import io.ataraxic.nomicflux.voyageur.Graph;
import io.ataraxic.nomicflux.voyageur.impl.ValueContext;
import io.ataraxic.nomicflux.voyageur.impl.ValueEdge;
import io.ataraxic.nomicflux.voyageur.impl.ValueNode;

public final class AdjListGraph<A, L, W>
implements Graph<A, ValueNode<A, L>, ValueEdge<A, L, W>, HashSet<ValueEdge<A, L, W>>, AdjListGraph<A, L, W>> {
    private final HashMap<ValueNode<A, L>, Tuple2<HashSet<ValueEdge<A, L, W>>, HashSet<ValueEdge<A, L, W>>>> graph;

    private AdjListGraph(HashMap<ValueNode<A, L>, Tuple2<HashSet<ValueEdge<A, L, W>>, HashSet<ValueEdge<A, L, W>>>> graph) {
        this.graph = graph;
    }

    @Override
    public Boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public static <A, L, W> AdjListGraph<A, L, W> emptyGraph() {
        return new AdjListGraph<A, L, W>(HashMap.hashMap((Tuple2[])new Tuple2[0]));
    }

    public static <A, L, W> AdjListGraph<A, L, W> singletonGraph(ValueNode<A, L> a) {
        return new AdjListGraph<A, L, W>(HashMap.hashMap((Tuple2[])new Tuple2[]{HList.tuple(a, (Object)HList.tuple((Object)HashSet.hashSet((Object[])new ValueEdge[0]), (Object)HashSet.hashSet((Object[])new ValueEdge[0])))}));
    }

    public static <A, L, W> AdjListGraph<A, L, W> fromEdge(ValueEdge<A, L, W> edge) {
        return AdjListGraph.emptyGraph().addEdge(edge);
    }

    public static <A, L, W> AdjListGraph<A, L, W> fromEdges(Iterable<ValueEdge<A, L, W>> edges) {
        return (AdjListGraph)FoldLeft.foldLeft(AdjListGraph::addEdge, AdjListGraph.emptyGraph(), edges);
    }

    public static <A> AdjListGraph<A, Unit, Unit> fromChain(Iterable<A> values) {
        return AdjListGraph.addFromChain(AdjListGraph.emptyGraph(), values);
    }

    private static <A> AdjListGraph<A, Unit, Unit> addFromChain(AdjListGraph<A, Unit, Unit> graph, Iterable<A> values) {
        return (AdjListGraph)FoldLeft.foldLeft((acc, next) -> acc.addEdge(ValueEdge.edgeFromTo(ValueNode.node(next._1()), ValueNode.node(next._2()))), graph, (Iterable)Zip.zip(values, (Iterable)Drop.drop((int)1, values)));
    }

    public static <A> AdjListGraph<A, Unit, Unit> fromChains(Iterable<Iterable<A>> values) {
        AdjListGraph empty = AdjListGraph.emptyGraph();
        return (AdjListGraph)FoldLeft.foldLeft(AdjListGraph::addFromChain, empty, values);
    }

    @Override
    public AdjListGraph<A, L, W> addEdge(ValueEdge<A, L, W> edge) {
        HashMap withNodes = this.addNode(edge.getNodeFrom()).addNode(edge.getNodeTo()).graph;
        HashMap updateFromEdge = (HashMap)withNodes.get((Object)edge.getNodeFrom()).fmap(res -> withNodes.put((Object)edge.getNodeFrom(), (Object)res.biMapL(l -> l.add((Object)edge)))).orElse(withNodes);
        HashMap updateToEdge = (HashMap)updateFromEdge.get((Object)edge.getNodeTo()).fmap(res -> updateFromEdge.put((Object)edge.getNodeTo(), (Object)res.biMapR(r -> r.add((Object)edge)))).orElse((Object)updateFromEdge);
        return new AdjListGraph<A, L, W>(updateToEdge);
    }

    @Override
    public AdjListGraph<A, L, W> removeEdge(ValueEdge<A, L, W> edge) {
        HashMap updateFromEdge = (HashMap)this.graph.get((Object)edge.getNodeFrom()).fmap(res -> this.graph.put((Object)edge.getNodeFrom(), (Object)res.biMapL(l -> l.remove((Object)edge)))).orElse(this.graph);
        HashMap updateToEdge = (HashMap)updateFromEdge.get((Object)edge.getNodeTo()).fmap(res -> updateFromEdge.put((Object)edge.getNodeTo(), (Object)res.biMapR(r -> r.remove((Object)edge)))).orElse((Object)updateFromEdge);
        return new AdjListGraph<A, L, W>(updateToEdge);
    }

    @Override
    public AdjListGraph<A, L, W> addNode(ValueNode<A, L> node) {
        Maybe tuple2Maybe = this.graph.get(node);
        return new AdjListGraph<A, L, W>((HashMap)tuple2Maybe.match(Constantly.constantly((Object)this.graph.put(node, (Object)HList.tuple((Object)HashSet.hashSet((Object[])new ValueEdge[0]), (Object)HashSet.hashSet((Object[])new ValueEdge[0])))), edges -> this.graph.put((Object)node, edges)));
    }

    @Override
    public AdjListGraph<A, L, W> removeNode(ValueNode<A, L> node) {
        AdjListGraph match = (AdjListGraph)this.graph.get(node).match(Constantly.constantly((Object)this), res -> (AdjListGraph)FoldLeft.foldLeft((g, e) -> g.removeEdge((ValueEdge)e).removeEdge((ValueEdge)e.swap()), (Object)this, (Iterable)((HashSet)res._1()).union((Set)res._2())));
        return new AdjListGraph<A, L, W>(match.graph.remove(node));
    }

    @Override
    public Maybe<Tuple2<Context<A, ValueNode<A, L>, ValueEdge<A, L, W>, HashSet<ValueEdge<A, L, W>>>, AdjListGraph<A, L, W>>> decompose() {
        return this.graph.head().flatMap(n -> this.atNode((ValueNode)n._1()).projectB());
    }

    @Override
    public Choice2<AdjListGraph<A, L, W>, Tuple2<Context<A, ValueNode<A, L>, ValueEdge<A, L, W>, HashSet<ValueEdge<A, L, W>>>, AdjListGraph<A, L, W>>> atNode(ValueNode<A, L> node) {
        Maybe view = this.graph.get(node);
        return (Choice2)view.match(Constantly.constantly((Object)Choice2.a((Object)this)), res -> Choice2.b((Object)HList.tuple(ValueContext.context(node, (HashSet)res._1(), (HashSet)res._2()), this.removeNode(node))));
    }
}

