/*
 * Decompiled with CFR 0.152.
 */
package io.architect;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class ArchitectSession {
    private HttpClient _httpClient;
    private CookieStore _cookieStore;
    private HttpClientContext _httpClientContext;
    private String _baseUrl;

    public ArchitectSession(String baseUrl) {
        this._baseUrl = baseUrl;
        this._cookieStore = new BasicCookieStore();
        this._httpClientContext = new HttpClientContext();
        this._httpClientContext.setAttribute("http.cookie-store", (Object)this._cookieStore);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("default").setConnectionRequestTimeout(60000).build();
        this._httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    private URI buildFullURI(String path, HashMap<String, String> params) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this._baseUrl).setPath(path);
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public HttpResponse post(String path, HashMap<String, String> params) throws IOException {
        URI fullUri = this.buildFullURI(path, params);
        return this._httpClient.execute((HttpUriRequest)new HttpPost(fullUri), (HttpContext)this._httpClientContext);
    }

    public HttpResponse post(String path) throws IOException {
        URI fullUri = this.buildFullURI(path, null);
        return this._httpClient.execute((HttpUriRequest)new HttpPost(fullUri), (HttpContext)this._httpClientContext);
    }

    public HttpResponse get(String path, HashMap<String, String> params) throws IOException {
        URI fullUri = this.buildFullURI(path, params);
        return this._httpClient.execute((HttpUriRequest)new HttpGet(fullUri), (HttpContext)this._httpClientContext);
    }

    public HttpResponse get(String path) throws IOException {
        URI fullUri = this.buildFullURI(path, null);
        return this._httpClient.execute((HttpUriRequest)new HttpGet(fullUri), (HttpContext)this._httpClientContext);
    }

    public HttpResponse put(String path, HashMap<String, String> params) throws IOException {
        URI fullUri = this.buildFullURI(path, params);
        return this._httpClient.execute((HttpUriRequest)new HttpPut(fullUri), (HttpContext)this._httpClientContext);
    }

    public HttpResponse put(String path) throws IOException {
        URI fullUri = this.buildFullURI(path, null);
        return this._httpClient.execute((HttpUriRequest)new HttpPut(fullUri), (HttpContext)this._httpClientContext);
    }

    public HttpResponse delete(String path, HashMap<String, String> params) throws IOException {
        URI fullUri = this.buildFullURI(path, params);
        return this._httpClient.execute((HttpUriRequest)new HttpDelete(fullUri), (HttpContext)this._httpClientContext);
    }

    public HttpResponse delete(String path) throws IOException {
        URI fullUri = this.buildFullURI(path, null);
        return this._httpClient.execute((HttpUriRequest)new HttpDelete(fullUri), (HttpContext)this._httpClientContext);
    }
}

