/*
 * Decompiled with CFR 0.152.
 */
package io.architect;

import io.architect.ArchitectService;
import io.architect.JsonStringParser;
import io.architect.Notifier;
import io.architect.ServiceCache;
import javax.json.JsonObject;

public class Architect {
    public static ArchitectService currentService() {
        return Architect.service(System.getenv("ARCHITECT_CURRENT_SERVICE"));
    }

    public static ArchitectService service(String serviceName) {
        ServiceCache cache = ServiceCache.getInstance();
        ArchitectService service = cache.getService(serviceName);
        if (service == null) {
            try {
                JsonObject config = JsonStringParser.parse(System.getenv("ARCHITECT")).getJsonObject(serviceName);
                service = new ArchitectService(serviceName, config);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(serviceName + " is required but has not been started.");
                System.exit(1);
            }
            cache.addService(serviceName, service);
        }
        return service;
    }

    public static JsonObject datastore(String datastoreName) {
        ServiceCache cache = ServiceCache.getInstance();
        JsonObject datastore = cache.getDatastore(datastoreName);
        if (datastore == null) {
            try {
                JsonObject datastores = Architect.currentService().config().getJsonObject("datastores");
                datastore = datastores.getJsonObject(datastoreName);
                cache.addDatastore(datastoreName, datastore);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(datastoreName + " is required but has not been started.");
                System.exit(1);
            }
        }
        return datastore;
    }

    public static Notifier notification(String eventName) {
        JsonObject notification;
        JsonObject subscriptions = Architect.currentService().config().getJsonObject("subscriptions");
        if (subscriptions == null) {
            System.err.println("No subscriptions found for service.");
            System.exit(1);
        }
        if ((notification = subscriptions.getJsonObject(eventName)) == null) {
            System.err.println(eventName + " event not found on service.");
            System.exit(1);
        }
        return new Notifier(notification);
    }
}

