package io.architect;

import java.util.ArrayList;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class Notifier {
    private JsonObject _targets;

    public Notifier(JsonObject targets) {
        _targets = targets;
    }

    public ArrayList<JsonObject> subscriptions() {
        ArrayList<JsonObject> subscribers = new ArrayList<JsonObject>();
        for (String subscriberName : _targets.keySet()) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("name", subscriberName);

            JsonObject targetServiceConfig = Architect.service(subscriberName).config();
            JsonObjectBuilder subscriberDetailsbuilder = Json.createObjectBuilder(targetServiceConfig);
            builder.addAll(subscriberDetailsbuilder);

            JsonObjectBuilder subscriberConfigBuilder = Json.createObjectBuilder(_targets.getJsonObject(subscriberName));
            builder.addAll(subscriberConfigBuilder);
            
            subscribers.add(builder.build());
        }
        return subscribers;
    }
}
