/*
 * Decompiled with CFR 0.152.
 */
package io.architect;

import io.architect.ArchitectService;
import java.util.concurrent.ConcurrentHashMap;
import javax.json.JsonObject;

class ServiceCache {
    private static ServiceCache _cache_instance = new ServiceCache();
    public ConcurrentHashMap<String, ArchitectService> _services = new ConcurrentHashMap();
    public ConcurrentHashMap<String, JsonObject> _datastores = new ConcurrentHashMap();

    protected ServiceCache() {
    }

    public static ServiceCache getInstance() {
        return _cache_instance;
    }

    public void addService(String serviceName, ArchitectService service) {
        this._services.put(serviceName, service);
    }

    public void addDatastore(String name, JsonObject storeConfig) {
        this._datastores.put(name, storeConfig);
    }

    public ArchitectService getService(String serviceName) {
        return this._services.get(serviceName);
    }

    public JsonObject getDatastore(String datastoreName) {
        return this._datastores.get(datastoreName);
    }
}

