package io.architect;

import java.util.concurrent.ConcurrentHashMap;

import javax.json.JsonObject;

class ServiceCache {
  private static ServiceCache _cache_instance = new ServiceCache();

  public ConcurrentHashMap<String, ArchitectService> _services;
  public ConcurrentHashMap<String, JsonObject> _datastores;

  protected ServiceCache() {
    _services = new ConcurrentHashMap<String, ArchitectService>();
    _datastores = new ConcurrentHashMap<String, JsonObject>();
  }

  public static ServiceCache getInstance() {
    return _cache_instance;
  }

  public void addService(String serviceName, ArchitectService service) {
    _services.put(serviceName, service);
  }

  public void addDatastore(String name, JsonObject storeConfig) {
    _datastores.put(name, storeConfig);
  }

  public ArchitectService getService(String serviceName) {
    return _services.get(serviceName);
  }

  public JsonObject getDatastore(String datastoreName) {
    return _datastores.get(datastoreName);
  }
}