/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.commons.time.test;

import io.archimedesfw.commons.time.ClockUtils;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lio/archimedesfw/commons/time/test/ClockTestUtils;", "", "()V", "fixedClock", "Ljava/time/Clock;", "localDateTime", "Ljava/time/LocalDateTime;", "runWithFixed", "T", "ts", "block", "Lkotlin/Function0;", "(Ljava/time/LocalDateTime;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "archimedes-commons-lang"})
public final class ClockTestUtils {
    @NotNull
    public static final ClockTestUtils INSTANCE;

    public final <T> T runWithFixed(@NotNull LocalDateTime ts, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Clock previous = ClockUtils.INSTANCE.getClock$archimedes_commons_lang();
        ClockUtils.INSTANCE.setClock$archimedes_commons_lang(this.fixedClock(ts));
        Object result = block.invoke();
        ClockUtils.INSTANCE.setClock$archimedes_commons_lang(previous);
        return (T)result;
    }

    private final Clock fixedClock(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZoneOffset.UTC).toInstant();
        Clock clock = Clock.fixed(instant, ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"Clock.fixed(instant, ZoneOffset.UTC)");
        return clock;
    }

    private ClockTestUtils() {
    }

    static {
        ClockTestUtils clockTestUtils;
        INSTANCE = clockTestUtils = new ClockTestUtils();
    }
}

