/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.commons.time;

import io.archimedesfw.commons.time.ClockUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001f"}, d2={"Lio/archimedesfw/commons/time/Interval;", "", "start", "Ljava/time/LocalDateTime;", "endInclusive", "(Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;)V", "days", "", "getDays", "()I", "endDayInclusive", "Ljava/time/LocalDate;", "getEndDayInclusive", "()Ljava/time/LocalDate;", "getEndInclusive", "()Ljava/time/LocalDateTime;", "hours", "getHours", "getStart", "startDay", "getStartDay", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "archimedes-commons-lang"})
public final class Interval {
    private final int hours;
    @NotNull
    private final LocalDate startDay;
    @NotNull
    private final LocalDate endDayInclusive;
    private final int days;
    @NotNull
    private final LocalDateTime start;
    @NotNull
    private final LocalDateTime endInclusive;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getHours() {
        return this.hours;
    }

    @NotNull
    public final LocalDate getStartDay() {
        return this.startDay;
    }

    @NotNull
    public final LocalDate getEndDayInclusive() {
        return this.endDayInclusive;
    }

    public final int getDays() {
        return this.days;
    }

    @NotNull
    public final LocalDateTime getStart() {
        return this.start;
    }

    @NotNull
    public final LocalDateTime getEndInclusive() {
        return this.endInclusive;
    }

    public Interval(@NotNull LocalDateTime start, @NotNull LocalDateTime endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this.start = start;
        this.endInclusive = endInclusive;
        boolean bl = this.start.compareTo(this.endInclusive) < 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The start '" + this.start + "' cannot be later than the end '" + this.endInclusive + "'.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.hours = (int)ChronoUnit.HOURS.between(this.start, this.endInclusive) + 1;
        LocalDate localDate = this.start.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"start.toLocalDate()");
        this.startDay = localDate;
        LocalDate localDate2 = this.endInclusive.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"endInclusive.toLocalDate()");
        this.endDayInclusive = localDate2;
        this.days = (int)ChronoUnit.DAYS.between(this.startDay, this.endDayInclusive) + 1;
    }

    @NotNull
    public final LocalDateTime component1() {
        return this.start;
    }

    @NotNull
    public final LocalDateTime component2() {
        return this.endInclusive;
    }

    @NotNull
    public final Interval copy(@NotNull LocalDateTime start, @NotNull LocalDateTime endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        return new Interval(start, endInclusive);
    }

    public static /* synthetic */ Interval copy$default(Interval interval, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            localDateTime = interval.start;
        }
        if ((n & 2) != 0) {
            localDateTime2 = interval.endInclusive;
        }
        return interval.copy(localDateTime, localDateTime2);
    }

    @NotNull
    public String toString() {
        return "Interval(start=" + this.start + ", endInclusive=" + this.endInclusive + ")";
    }

    public int hashCode() {
        LocalDateTime localDateTime = this.start;
        LocalDateTime localDateTime2 = this.endInclusive;
        return (localDateTime != null ? ((Object)localDateTime).hashCode() : 0) * 31 + (localDateTime2 != null ? ((Object)localDateTime2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Interval)) break block3;
                Interval interval = (Interval)object;
                if (!Intrinsics.areEqual((Object)this.start, (Object)interval.start) || !Intrinsics.areEqual((Object)this.endInclusive, (Object)interval.endInclusive)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/archimedesfw/commons/time/Interval$Companion;", "", "()V", "ofMonth", "Lio/archimedesfw/commons/time/Interval;", "localDate", "Ljava/time/LocalDate;", "zoneId", "Ljava/time/ZoneId;", "archimedes-commons-lang"})
    public static final class Companion {
        @NotNull
        public final Interval ofMonth(@NotNull LocalDate localDate, @NotNull ZoneId zoneId) {
            Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            LocalDateTime start = localDate.withDayOfMonth(1).atStartOfDay();
            LocalDateTime endInclusive = start.plusMonths(1L).minusHours(1L);
            LocalDateTime localDateTime = start;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"start");
            LocalDateTime utcStart = ClockUtils.INSTANCE.toUtc(localDateTime, zoneId);
            LocalDateTime localDateTime2 = endInclusive;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"endInclusive");
            LocalDateTime utcEndInclusive = ClockUtils.INSTANCE.toUtc(localDateTime2, zoneId);
            return new Interval(utcStart, utcEndInclusive);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

