/*
 * Decompiled with CFR 0.152.
 */
package io.archimedesfw.commons.time;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/archimedesfw/commons/time/ClockUtils;", "", "()V", "clock", "Ljava/time/Clock;", "getClock$archimedes_commons_lang", "()Ljava/time/Clock;", "setClock$archimedes_commons_lang", "(Ljava/time/Clock;)V", "nowUtc", "Ljava/time/LocalDateTime;", "toUtc", "ts", "fromZoneId", "Ljava/time/ZoneId;", "zoned", "Ljava/time/ZonedDateTime;", "toZone", "utc", "toZoneId", "toZonedDateTime", "archimedes-commons-lang"})
public final class ClockUtils {
    @NotNull
    private static Clock clock;
    @NotNull
    public static final ClockUtils INSTANCE;

    @NotNull
    public final Clock getClock$archimedes_commons_lang() {
        return clock;
    }

    public final void setClock$archimedes_commons_lang(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"<set-?>");
        ClockUtils.clock = clock;
    }

    @NotNull
    public final LocalDateTime nowUtc() {
        LocalDateTime localDateTime = LocalDateTime.now(clock);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.now(clock)");
        return localDateTime;
    }

    @NotNull
    public final LocalDateTime toUtc(@NotNull LocalDateTime ts, @NotNull ZoneId fromZoneId) {
        ZonedDateTime zoned;
        Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
        Intrinsics.checkNotNullParameter((Object)fromZoneId, (String)"fromZoneId");
        ZonedDateTime zonedDateTime = zoned = ts.atZone(fromZoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"zoned");
        return this.toUtc(zonedDateTime);
    }

    @NotNull
    public final LocalDateTime toUtc(@NotNull ZonedDateTime zoned) {
        Intrinsics.checkNotNullParameter((Object)zoned, (String)"zoned");
        ZonedDateTime utc = zoned.withZoneSameInstant(ZoneOffset.UTC);
        LocalDateTime localDateTime = utc.toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"utc.toLocalDateTime()");
        return localDateTime;
    }

    @NotNull
    public final LocalDateTime toZone(@NotNull LocalDateTime utc, @NotNull ZoneId toZoneId) {
        Intrinsics.checkNotNullParameter((Object)utc, (String)"utc");
        Intrinsics.checkNotNullParameter((Object)toZoneId, (String)"toZoneId");
        ZonedDateTime zoned = this.toZonedDateTime(utc, toZoneId);
        LocalDateTime localDateTime = zoned.toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"zoned.toLocalDateTime()");
        return localDateTime;
    }

    @NotNull
    public final ZonedDateTime toZonedDateTime(@NotNull LocalDateTime utc, @NotNull ZoneId toZoneId) {
        Intrinsics.checkNotNullParameter((Object)utc, (String)"utc");
        Intrinsics.checkNotNullParameter((Object)toZoneId, (String)"toZoneId");
        OffsetDateTime offsetDateTime = utc.atOffset(ZoneOffset.UTC);
        ZonedDateTime zonedDateTime = offsetDateTime.atZoneSameInstant(toZoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"offsetDateTime.atZoneSameInstant(toZoneId)");
        return zonedDateTime;
    }

    private ClockUtils() {
    }

    static {
        ClockUtils clockUtils;
        INSTANCE = clockUtils = new ClockUtils();
        Clock clock = Clock.system(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"Clock.system(ZoneOffset.UTC)");
        ClockUtils.clock = clock;
    }
}

