/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.ErlangTermDecodeException;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import lombok.NonNull;

public class ErlangInteger
extends ErlangTerm {
    private static final long serialVersionUID = -1757584303003802030L;
    private static final int MAX_SMALL_INTEGER = 255;
    private static final int MAX_INTEGER = 0x7FFFFFF;
    private static final int MIN_INTEGER = -134217729;
    private static final int MAX_SMALL_BIG_BYTES_LENGTH = 255;
    private final BigInteger value;
    private byte[] cachedMagnitude;

    public static ErlangInteger cached(byte value) {
        return ErlangIntegerCache.CACHE[value + 128];
    }

    public static ErlangInteger cached(char value) {
        if (value <= '\u007f') {
            return ErlangIntegerCache.CACHE[value + 128];
        }
        return new ErlangInteger(value);
    }

    public static ErlangInteger cached(short value) {
        if (value >= -128 && value <= 127) {
            return ErlangIntegerCache.CACHE[value + 128];
        }
        return new ErlangInteger(value);
    }

    public static ErlangInteger cached(int value) {
        if (value >= -128 && value <= 127) {
            return ErlangIntegerCache.CACHE[value + 128];
        }
        return new ErlangInteger(value);
    }

    public static ErlangInteger cached(long value) {
        if (value >= -128L && value <= 127L) {
            return ErlangIntegerCache.CACHE[(int)value + 128];
        }
        return new ErlangInteger(value);
    }

    public static ErlangInteger cached(BigInteger value) {
        if (value.bitLength() < 8) {
            return ErlangInteger.cached(value.longValue());
        }
        return new ErlangInteger(value);
    }

    public ErlangInteger(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        switch (type) {
            case SMALL_INTEGER: {
                this.value = BigInteger.valueOf(buffer.readUnsignedByte());
                break;
            }
            case INTEGER: {
                this.value = BigInteger.valueOf(buffer.readInt());
                break;
            }
            case SMALL_BIG: 
            case LARGE_BIG: {
                int arity = type == TermType.SMALL_BIG ? buffer.readByte() : buffer.readInt();
                byte sign = buffer.readByte();
                byte[] bytes = new byte[arity];
                buffer.readBytes(bytes);
                this.reverse(bytes);
                this.value = sign == 0 ? new BigInteger(bytes) : new BigInteger(bytes).negate();
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), type);
            }
        }
    }

    public ErlangInteger(char value) {
        this((long)value);
    }

    public ErlangInteger(byte value) {
        this((long)value & 0xFFL);
    }

    public ErlangInteger(short value) {
        this((long)value);
    }

    public ErlangInteger(int value) {
        this((long)value);
    }

    public ErlangInteger(long value) {
        this.value = BigInteger.valueOf(value);
        this.setupType(value);
    }

    public ErlangInteger(@NonNull BigInteger value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.value = value;
        if (value.bitLength() < 8) {
            this.setupType(value.longValue());
        } else if (value.abs().toByteArray().length <= 255) {
            this.setType(TermType.SMALL_BIG);
        } else {
            this.setType(TermType.LARGE_BIG);
        }
    }

    @Override
    public boolean isByte() {
        return this.value.bitLength() + 1 <= 8;
    }

    @Override
    public boolean isShort() {
        return this.value.bitLength() + 1 <= 16;
    }

    @Override
    public boolean isInt() {
        return this.value.bitLength() + 1 <= 32;
    }

    @Override
    public boolean isLong() {
        return this.value.bitLength() + 1 <= 64;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public Number asNumber() {
        return this.value;
    }

    @Override
    public byte[] asBinary(byte[] defaultValue) {
        return this.value.toByteArray();
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return this.value.equals(BigInteger.ZERO);
    }

    @Override
    public String asText(String defaultValue) {
        return this.value.toString();
    }

    @Override
    public byte asByte(byte defaultValue) {
        return this.value.byteValue();
    }

    @Override
    public short asShort(short defaultValue) {
        return this.value.shortValue();
    }

    @Override
    public int asInt(int defaultValue) {
        return this.value.intValue();
    }

    @Override
    public long asLong(long defaultValue) {
        return this.value.longValue();
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        return this.value;
    }

    @Override
    public float asFloat(float defaultValue) {
        return this.value.floatValue();
    }

    @Override
    public double asDouble(double defaultValue) {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        return new BigDecimal(this.value);
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        switch (this.getType()) {
            case SMALL_INTEGER: {
                buffer.writeByte((int)this.value.shortValue());
                break;
            }
            case INTEGER: {
                buffer.writeInt(this.value.intValue());
                break;
            }
            case SMALL_BIG: 
            case LARGE_BIG: {
                int length;
                if (this.cachedMagnitude == null) {
                    int index;
                    byte[] bytes = this.value.abs().toByteArray();
                    for (index = 0; index < bytes.length && bytes[index] == 0; ++index) {
                    }
                    this.cachedMagnitude = Arrays.copyOfRange(bytes, index, bytes.length);
                    this.reverse(this.cachedMagnitude);
                }
                if (((length = this.cachedMagnitude.length) & 0xFF) == length) {
                    buffer.writeByte(length);
                } else {
                    buffer.writeInt(length);
                }
                int sign = this.value.signum() < 0 ? 1 : 0;
                buffer.writeByte(sign);
                buffer.writeBytes(this.cachedMagnitude);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
    }

    private void setupType(long longValue) {
        if ((longValue & 0xFFL) == longValue) {
            this.setType(TermType.SMALL_INTEGER);
        } else if (longValue >= -134217729L && longValue <= 0x7FFFFFFL) {
            this.setType(TermType.INTEGER);
        } else if (this.value.abs().toByteArray().length <= 255) {
            this.setType(TermType.SMALL_BIG);
        } else {
            throw new ErlangTermDecodeException();
        }
    }

    private void reverse(byte[] data) {
        int left = 0;
        for (int right = data.length - 1; left < right; ++left, --right) {
            byte temp = data[left];
            data[left] = data[right];
            data[right] = temp;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangInteger(value=" + this.value + ", cachedMagnitude=" + Arrays.toString(this.cachedMagnitude) + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangInteger)) {
            return false;
        }
        ErlangInteger other = (ErlangInteger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigInteger this$value = this.value;
        BigInteger other$value = other.value;
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        return Arrays.equals(this.cachedMagnitude, other.cachedMagnitude);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangInteger;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigInteger $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        result = result * 59 + Arrays.hashCode(this.cachedMagnitude);
        return result;
    }

    private static class ErlangIntegerCache {
        private static final int LOW = -128;
        private static final int HIGH = 127;
        private static final ErlangInteger[] CACHE = new ErlangInteger[256];

        private ErlangIntegerCache() {
        }

        static {
            int value = -128;
            for (int index = 0; index < CACHE.length; ++index) {
                ErlangIntegerCache.CACHE[index] = new ErlangInteger(value++);
            }
        }
    }
}

