/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;

public class ErlangFloat
extends ErlangTerm {
    private static final long serialVersionUID = -4146479045850295285L;
    private final double value;

    public ErlangFloat(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        switch (type) {
            case FLOAT: {
                byte[] bytes = new byte[31];
                buffer.readBytes(bytes);
                String string = new String(bytes, StandardCharsets.ISO_8859_1);
                this.value = Double.valueOf(string);
                break;
            }
            case NEW_FLOAT: {
                long bits = buffer.readLong();
                this.value = Double.longBitsToDouble(bits);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), type);
            }
        }
    }

    public ErlangFloat(double value) {
        super(TermType.NEW_FLOAT);
        this.value = value;
    }

    public ErlangFloat(float value) {
        super(TermType.NEW_FLOAT);
        this.value = value;
    }

    public ErlangFloat(BigDecimal value) {
        super(TermType.NEW_FLOAT);
        this.value = value.doubleValue();
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public Number asNumber() {
        return this.value;
    }

    @Override
    public String asText(String defaultValue) {
        return Double.toString(this.value);
    }

    @Override
    public short asShort(short defaultValue) {
        return (short)this.value;
    }

    @Override
    public int asInt(int defaultValue) {
        return (int)this.value;
    }

    @Override
    public long asLong(long defaultValue) {
        return (long)this.value;
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        return this.asDecimal().toBigInteger();
    }

    @Override
    public float asFloat(float defaultValue) {
        return (float)this.value;
    }

    @Override
    public double asDouble(double defaultValue) {
        return this.value;
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        switch (this.getType()) {
            case FLOAT: {
                String string = String.format("%031.20e", this.value);
                buffer.writeCharSequence((CharSequence)string, StandardCharsets.ISO_8859_1);
                break;
            }
            case NEW_FLOAT: {
                long bits = Double.doubleToLongBits(this.value);
                buffer.writeLong(bits);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangFloat(value=" + this.value + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangFloat)) {
            return false;
        }
        ErlangFloat other = (ErlangFloat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.value, other.value) == 0;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangFloat;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $value = Double.doubleToLongBits(this.value);
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }
}

