/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.Erlang;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.netty.buffer.ByteBuf;
import lombok.NonNull;

public class ErlangExternalFunction
extends ErlangTerm {
    private static final long serialVersionUID = -8415499460097963982L;
    private final String module;
    private final String name;
    private final int arity;

    public ErlangExternalFunction(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        Object atomModule = ErlangTerm.newInstance(buffer);
        this.module = atomModule.asText();
        Object atomName = ErlangTerm.newInstance(buffer);
        this.name = atomName.asText();
        Object numberArity = ErlangTerm.newInstance(buffer);
        this.arity = numberArity.asInt();
    }

    public ErlangExternalFunction(@NonNull String module, @NonNull String name, int arity) {
        super(TermType.EXTERNAL_FUNCTION);
        if (module == null) {
            throw new NullPointerException("module is marked @NonNull but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.module = module;
        this.name = name;
        this.arity = arity;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        Erlang.atom(this.module).writeTo(buffer);
        Erlang.atom(this.name).writeTo(buffer);
        Erlang.number(this.arity).writeTo(buffer);
    }

    @SuppressFBWarnings(justification="generated code")
    public static ErlangExternalFunctionBuilder builder() {
        return new ErlangExternalFunctionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String getModule() {
        return this.module;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getArity() {
        return this.arity;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangExternalFunction(module=" + this.getModule() + ", name=" + this.getName() + ", arity=" + this.getArity() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangExternalFunction)) {
            return false;
        }
        ErlangExternalFunction other = (ErlangExternalFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return this.getArity() == other.getArity();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangExternalFunction;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getArity();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ErlangExternalFunctionBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String module;
        @SuppressFBWarnings(justification="generated code")
        private String name;
        @SuppressFBWarnings(justification="generated code")
        private int arity;

        @SuppressFBWarnings(justification="generated code")
        ErlangExternalFunctionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangExternalFunctionBuilder module(String module) {
            this.module = module;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangExternalFunctionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangExternalFunctionBuilder arity(int arity) {
            this.arity = arity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangExternalFunction build() {
            return new ErlangExternalFunction(this.module, this.name, this.arity);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ErlangExternalFunction.ErlangExternalFunctionBuilder(module=" + this.module + ", name=" + this.name + ", arity=" + this.arity + ")";
        }
    }
}

