/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.Erlang;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.ErlangTermDecodeException;
import io.appulse.encon.terms.exception.ErlangTermValidationException;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import lombok.NonNull;

public class ErlangBitString
extends ErlangTerm {
    private static final long serialVersionUID = 7484207266013629164L;
    private final byte[] bits;
    private final int pad;

    public ErlangBitString(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        int length = buffer.readInt();
        byte tail = buffer.readByte();
        if (length == 0 && tail != 0) {
            throw new ErlangTermDecodeException("Length 0 on BitString with tail bit count: " + tail);
        }
        if (tail < 0 || tail > 7) {
            throw new ErlangTermDecodeException("Wrong tail bit count: " + tail);
        }
        this.bits = new byte[length];
        buffer.readBytes(this.bits);
        this.pad = 8 - tail;
        this.validate();
    }

    public ErlangBitString(@NonNull byte[] bits, int pad) {
        super(TermType.BIT_BINNARY);
        if (bits == null) {
            throw new NullPointerException("bits is marked @NonNull but is null");
        }
        this.bits = new byte[bits.length];
        System.arraycopy(bits, 0, this.bits, 0, bits.length);
        this.pad = pad;
        this.validate();
    }

    public byte[] getBits() {
        return (byte[])this.bits.clone();
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        if (this.pad == 0) {
            int position = buffer.writerIndex();
            buffer.writerIndex(position - 1);
            Erlang.binary(this.bits).writeTo(buffer);
        } else {
            buffer.writeInt(this.bits.length);
            buffer.writeByte(8 - this.pad);
            buffer.writeBytes(this.bits);
        }
    }

    private void validate() {
        if (this.pad < 0 || this.pad > 7) {
            throw new ErlangTermValidationException("Padding must be in range 0..7");
        }
        if (this.pad != 0 && this.bits.length == 0) {
            throw new ErlangTermValidationException("Padding on zero length BitString");
        }
        if (this.bits.length != 0) {
            int n = this.bits.length - 1;
            this.bits[n] = (byte)(this.bits[n] & ~((1 << this.pad) - 1));
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public static ErlangBitStringBuilder builder() {
        return new ErlangBitStringBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public int getPad() {
        return this.pad;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangBitString(bits=" + Arrays.toString(this.getBits()) + ", pad=" + this.getPad() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangBitString)) {
            return false;
        }
        ErlangBitString other = (ErlangBitString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getBits(), other.getBits())) {
            return false;
        }
        return this.getPad() == other.getPad();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangBitString;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getBits());
        result = result * 59 + this.getPad();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ErlangBitStringBuilder {
        @SuppressFBWarnings(justification="generated code")
        private byte[] bits;
        @SuppressFBWarnings(justification="generated code")
        private int pad;

        @SuppressFBWarnings(justification="generated code")
        ErlangBitStringBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangBitStringBuilder bits(byte[] bits) {
            this.bits = bits;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangBitStringBuilder pad(int pad) {
            this.pad = pad;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangBitString build() {
            return new ErlangBitString(this.bits, this.pad);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ErlangBitString.ErlangBitStringBuilder(bits=" + Arrays.toString(this.bits) + ", pad=" + this.pad + ")";
        }
    }
}

