/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.appulse.utils.cache.LruCache;
import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import lombok.NonNull;

public class ErlangAtom
extends ErlangTerm {
    private static final long serialVersionUID = -2748345367418129439L;
    private static final int MAX_ATOM_CODE_POINTS_LENGTH = 255;
    private static final int MAX_SMALL_ATOM_BYTES_LENGTH = 255;
    private static final LruCache<Integer, ErlangAtom> CACHE = new LruCache(1000);
    private static final ErlangAtom ATOM_TRUE = ErlangAtom.cached(Boolean.TRUE.toString().toLowerCase(Locale.ENGLISH));
    private static final ErlangAtom ATOM_FALSE = ErlangAtom.cached(Boolean.FALSE.toString().toLowerCase(Locale.ENGLISH));
    private String value;
    private final byte[] bytes;
    private final transient Charset charset;

    public static ErlangAtom cached(boolean value) {
        return value ? ATOM_TRUE : ATOM_FALSE;
    }

    public static ErlangAtom cached(String value) {
        Charset charset = StandardCharsets.UTF_8;
        byte[] bytes = value.getBytes(charset);
        int hashCode = Arrays.hashCode(bytes);
        return (ErlangAtom)CACHE.computeIfAbsent((Object)hashCode, key -> new ErlangAtom(value, charset, bytes));
    }

    public static ErlangAtom cached(TermType type, ByteBuf buffer) {
        ByteArrayHashCode byteProcessor = new ByteArrayHashCode();
        int length = type == TermType.SMALL_ATOM || type == TermType.SMALL_ATOM_UTF8 ? buffer.readUnsignedByte() : buffer.readUnsignedShort();
        buffer.forEachByte(buffer.readerIndex(), length, (ByteProcessor)byteProcessor);
        return (ErlangAtom)CACHE.compute((Object)byteProcessor.getHashCode(), (key, value) -> {
            if (value == null) {
                return new ErlangAtom(type, buffer, length);
            }
            buffer.skipBytes(length);
            return value;
        });
    }

    public ErlangAtom(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.value = value.codePointCount(0, value.length()) <= 255 ? value : new String(value.codePoints().toArray(), 0, 255);
        this.charset = StandardCharsets.UTF_8;
        this.bytes = this.value.getBytes(this.charset);
        if (this.bytes.length > 255) {
            this.setType(TermType.ATOM_UTF8);
        } else {
            this.setType(TermType.SMALL_ATOM_UTF8);
        }
    }

    public ErlangAtom(boolean value) {
        super(TermType.SMALL_ATOM_UTF8);
        this.charset = StandardCharsets.UTF_8;
        this.value = Boolean.toString(value);
        this.bytes = value ? Boolean.TRUE.toString().getBytes(this.charset) : Boolean.FALSE.toString().getBytes(this.charset);
    }

    private ErlangAtom(TermType type, ByteBuf buffer, int length) {
        super(type);
        this.charset = type == TermType.SMALL_ATOM_UTF8 || type == TermType.ATOM_UTF8 ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        this.bytes = new byte[length];
        buffer.readBytes(this.bytes);
    }

    private ErlangAtom(String value, Charset charset, byte[] bytes) {
        this.value = value.codePointCount(0, value.length()) <= 255 ? value : new String(value.codePoints().toArray(), 0, 255);
        this.charset = charset;
        this.bytes = bytes;
        if (bytes.length > 255) {
            this.setType(TermType.ATOM_UTF8);
        } else {
            this.setType(TermType.SMALL_ATOM_UTF8);
        }
    }

    @Override
    public boolean isBoolean() {
        return "true".equalsIgnoreCase(this.asText()) || "false".equalsIgnoreCase(this.asText());
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return "true".equalsIgnoreCase(this.asText());
    }

    @Override
    public String asText(String defaultValue) {
        if (this.value == null) {
            this.value = new String(this.bytes, this.charset);
        }
        return this.value;
    }

    @Override
    public byte[] asBinary(byte[] defaultValue) {
        return (byte[])this.bytes.clone();
    }

    @Override
    public ErlangAtom asAtom() {
        return this;
    }

    @Override
    public boolean isTextual() {
        return true;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        switch (this.getType()) {
            case SMALL_ATOM_UTF8: 
            case SMALL_ATOM: {
                buffer.writeByte(this.bytes.length);
                break;
            }
            case ATOM_UTF8: 
            case ATOM: {
                buffer.writeShort(this.bytes.length);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
        buffer.writeBytes(this.bytes);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangAtom(value=" + this.value + ", bytes=" + Arrays.toString(this.bytes) + ", charset=" + this.charset + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangAtom)) {
            return false;
        }
        ErlangAtom other = (ErlangAtom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangAtom;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.bytes);
        return result;
    }

    private static class ByteArrayHashCode
    implements ByteProcessor {
        private int hashCode = 1;

        private ByteArrayHashCode() {
        }

        public boolean process(byte value) throws Exception {
            this.hashCode = 31 * this.hashCode + value;
            return true;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getHashCode() {
            return this.hashCode;
        }
    }
}

