/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.common.NodeDescriptor;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.appulse.encon.terms.type.ErlangAtom;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import lombok.NonNull;

public class ErlangPid
extends ErlangTerm {
    private static final long serialVersionUID = 7083159089429831665L;
    private NodeDescriptor descriptor;
    private final ErlangAtom node;
    private final int id;
    private final int serial;
    private final int creation;

    public ErlangPid(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        this.node = (ErlangAtom)ErlangTerm.newInstance(buffer);
        switch (type) {
            case PID: {
                this.id = buffer.readInt() & Short.MAX_VALUE;
                this.serial = buffer.readInt() & 0x1FFF;
                this.creation = buffer.readUnsignedByte() & 3;
                break;
            }
            case NEW_PID: {
                this.id = buffer.readInt();
                this.serial = buffer.readInt();
                this.creation = buffer.readInt();
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), type);
            }
        }
    }

    private ErlangPid(TermType type, @NonNull String node, int id, int serial, int creation) {
        super(Optional.ofNullable(type).orElse(TermType.PID));
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        this.node = new ErlangAtom(node);
        if (this.getType() == TermType.PID) {
            this.id = id & Short.MAX_VALUE;
            this.serial = serial & 0x1FFF;
            this.creation = creation & 3;
        } else {
            this.id = id;
            this.serial = serial;
            this.creation = creation;
        }
    }

    @Override
    public String asText(String defaultValue) {
        return this.toString();
    }

    @Override
    public ErlangPid asPid() {
        return this;
    }

    public String toString() {
        return "#PID<" + this.creation + '.' + this.id + '.' + this.serial + '>';
    }

    public final NodeDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = NodeDescriptor.from((String)this.node.asText());
        }
        return this.descriptor;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        this.node.writeTo(buffer);
        buffer.writeInt(this.id);
        buffer.writeInt(this.serial);
        switch (this.getType()) {
            case PID: {
                buffer.writeByte(this.creation);
                break;
            }
            case NEW_PID: {
                buffer.writeInt(this.creation);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public static ErlangPidBuilder builder() {
        return new ErlangPidBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public ErlangAtom getNode() {
        return this.node;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getSerial() {
        return this.serial;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCreation() {
        return this.creation;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangPid)) {
            return false;
        }
        ErlangPid other = (ErlangPid)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeDescriptor this$descriptor = this.getDescriptor();
        NodeDescriptor other$descriptor = other.getDescriptor();
        if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
            return false;
        }
        ErlangAtom this$node = this.getNode();
        ErlangAtom other$node = other.getNode();
        if (this$node == null ? other$node != null : !((Object)this$node).equals(other$node)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getSerial() != other.getSerial()) {
            return false;
        }
        return this.getCreation() == other.getCreation();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangPid;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeDescriptor $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        ErlangAtom $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : ((Object)$node).hashCode());
        result = result * 59 + this.getId();
        result = result * 59 + this.getSerial();
        result = result * 59 + this.getCreation();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ErlangPidBuilder {
        @SuppressFBWarnings(justification="generated code")
        private TermType type;
        @SuppressFBWarnings(justification="generated code")
        private String node;
        @SuppressFBWarnings(justification="generated code")
        private int id;
        @SuppressFBWarnings(justification="generated code")
        private int serial;
        @SuppressFBWarnings(justification="generated code")
        private int creation;

        @SuppressFBWarnings(justification="generated code")
        ErlangPidBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangPidBuilder type(TermType type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangPidBuilder node(String node) {
            this.node = node;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangPidBuilder id(int id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangPidBuilder serial(int serial) {
            this.serial = serial;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangPidBuilder creation(int creation) {
            this.creation = creation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangPid build() {
            return new ErlangPid(this.type, this.node, this.id, this.serial, this.creation);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ErlangPid.ErlangPidBuilder(type=" + (Object)((Object)this.type) + ", node=" + this.node + ", id=" + this.id + ", serial=" + this.serial + ", creation=" + this.creation + ")";
        }
    }
}

