/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.Erlang;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.term.IntegerTerm;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;

public class ErlangList
extends ErlangTerm {
    private static final long serialVersionUID = 6923705109793240922L;
    private final ErlangTerm[] elements;
    private final ErlangTerm tail;

    public ErlangList(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        int arity = buffer.readInt();
        this.elements = (ErlangTerm[])IntStream.range(0, arity).boxed().map(it -> ErlangTerm.newInstance(buffer)).toArray(ErlangTerm[]::new);
        this.tail = ErlangTerm.newInstance(buffer);
    }

    public ErlangList(ErlangTerm ... elements) {
        this(Arrays.asList(elements));
    }

    public ErlangList(@NonNull Collection<ErlangTerm> elements) {
        super(TermType.LIST);
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        this.elements = elements.toArray(new ErlangTerm[0]);
        this.tail = Erlang.NIL;
    }

    public ErlangList(ErlangTerm tail, List<ErlangTerm> elements) {
        super(TermType.LIST);
        this.elements = Optional.ofNullable(elements).map(it -> it.toArray(new ErlangTerm[0])).orElse(new ErlangTerm[0]);
        this.tail = tail;
    }

    public boolean isProper() {
        return this.tail == null || this.tail.isNil();
    }

    @Override
    public boolean isTextual() {
        return this.isProper() && Stream.of(this.elements).allMatch(IntegerTerm::isIntegralNumber);
    }

    @Override
    public String asText(String defaultValue) {
        if (!this.isTextual()) {
            return defaultValue;
        }
        int[] codePoints = Stream.of(this.elements).mapToInt(IntegerTerm::asInt).toArray();
        return new String(codePoints, 0, codePoints.length);
    }

    @Override
    public ErlangList asList() {
        return this;
    }

    @Override
    public Iterator<ErlangTerm> elements() {
        return Stream.of(this.elements).iterator();
    }

    @Override
    public ErlangTerm getUnsafe(int index) {
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        buffer.writeInt(this.elements.length);
        Stream.of(this.elements).forEachOrdered(it -> it.writeTo(buffer));
        this.tail.writeTo(buffer);
    }

    @SuppressFBWarnings(justification="generated code")
    public static ErlangListBuilder builder() {
        return new ErlangListBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangList(elements=" + Arrays.deepToString(this.elements) + ", tail=" + this.getTail() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangList)) {
            return false;
        }
        ErlangList other = (ErlangList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.deepEquals(this.elements, other.elements)) {
            return false;
        }
        ErlangTerm this$tail = this.getTail();
        ErlangTerm other$tail = other.getTail();
        return !(this$tail == null ? other$tail != null : !((Object)this$tail).equals(other$tail));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangList;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.elements);
        ErlangTerm $tail = this.getTail();
        result = result * 59 + ($tail == null ? 43 : ((Object)$tail).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public ErlangTerm getTail() {
        return this.tail;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ErlangListBuilder {
        @SuppressFBWarnings(justification="generated code")
        private ErlangTerm tail;
        @SuppressFBWarnings(justification="generated code")
        private ArrayList<ErlangTerm> elements;

        @SuppressFBWarnings(justification="generated code")
        ErlangListBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangListBuilder tail(ErlangTerm tail) {
            this.tail = tail;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangListBuilder element(ErlangTerm element) {
            if (this.elements == null) {
                this.elements = new ArrayList();
            }
            this.elements.add(element);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangListBuilder elements(Collection<? extends ErlangTerm> elements) {
            if (this.elements == null) {
                this.elements = new ArrayList();
            }
            this.elements.addAll(elements);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangListBuilder clearElements() {
            if (this.elements != null) {
                this.elements.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangList build() {
            List<ErlangTerm> elements;
            switch (this.elements == null ? 0 : this.elements.size()) {
                case 0: {
                    elements = Collections.emptyList();
                    break;
                }
                case 1: {
                    elements = Collections.singletonList(this.elements.get(0));
                    break;
                }
                default: {
                    elements = Collections.unmodifiableList(new ArrayList<ErlangTerm>(this.elements));
                }
            }
            return new ErlangList(this.tail, elements);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ErlangList.ErlangListBuilder(tail=" + this.tail + ", elements=" + this.elements + ")";
        }
    }
}

