/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms;

import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.exception.ErlangTermValidationException;
import io.appulse.encon.terms.type.ErlangAtom;
import io.appulse.encon.terms.type.ErlangBinary;
import io.appulse.encon.terms.type.ErlangBitString;
import io.appulse.encon.terms.type.ErlangFloat;
import io.appulse.encon.terms.type.ErlangInteger;
import io.appulse.encon.terms.type.ErlangList;
import io.appulse.encon.terms.type.ErlangMap;
import io.appulse.encon.terms.type.ErlangNil;
import io.appulse.encon.terms.type.ErlangString;
import io.appulse.encon.terms.type.ErlangTuple;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.NonNull;

public final class Erlang {
    public static final ErlangNil NIL = new ErlangNil();
    public static final ErlangAtom EMPTY_ATOM = new ErlangAtom("");

    public static ErlangAtom atom(boolean value) {
        return new ErlangAtom(value);
    }

    public static ErlangAtom atom(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return new ErlangAtom(value);
    }

    public static ErlangInteger number(char value) {
        return new ErlangInteger(value);
    }

    public static ErlangInteger number(byte value) {
        return new ErlangInteger(value);
    }

    public static ErlangInteger number(short value) {
        return new ErlangInteger(value);
    }

    public static ErlangInteger number(int value) {
        return new ErlangInteger(value);
    }

    public static ErlangInteger number(long value) {
        return new ErlangInteger(value);
    }

    public static ErlangInteger number(@NonNull BigInteger value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return new ErlangInteger(value);
    }

    public static ErlangFloat number(float value) {
        return new ErlangFloat(value);
    }

    public static ErlangFloat number(double value) {
        return new ErlangFloat(value);
    }

    public static ErlangFloat number(BigDecimal value) {
        return new ErlangFloat(value);
    }

    public static ErlangBinary binary(@NonNull byte[] value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return new ErlangBinary(value);
    }

    public static ErlangBitString bitstr(@NonNull byte[] bits, int pad) {
        if (bits == null) {
            throw new NullPointerException("bits is marked @NonNull but is null");
        }
        return new ErlangBitString(bits, pad);
    }

    public static ErlangString string(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return new ErlangString(value);
    }

    public static ErlangBinary bstring(String value) {
        return Erlang.bstring(value, Charset.defaultCharset());
    }

    public static ErlangBinary bstring(String value, @NonNull String charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked @NonNull but is null");
        }
        return Erlang.bstring(value, Charset.forName(charset));
    }

    public static ErlangBinary bstring(@NonNull String value, @NonNull Charset charset) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked @NonNull but is null");
        }
        byte[] bytes = value.getBytes(charset);
        return Erlang.binary(bytes);
    }

    public static ErlangTuple tuple(ErlangTerm ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        return new ErlangTuple(elements);
    }

    public static ErlangTuple tuple(@NonNull Collection<ErlangTerm> elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        return new ErlangTuple(elements);
    }

    public static ErlangList list(ErlangTerm ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        return new ErlangList(elements);
    }

    public static ErlangList list(@NonNull Collection<ErlangTerm> elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        return new ErlangList(elements);
    }

    public static ErlangList list(@NonNull ErlangTerm tail, @NonNull List<ErlangTerm> elements) {
        if (tail == null) {
            throw new NullPointerException("tail is marked @NonNull but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        return new ErlangList(tail, elements);
    }

    public static ErlangMap map(ErlangTerm ... keysAndValues) {
        if (keysAndValues == null) {
            throw new NullPointerException("keysAndValues is marked @NonNull but is null");
        }
        if (keysAndValues.length % 2 != 0) {
            throw new ErlangTermValidationException("Keys and Values array must be even");
        }
        LinkedHashMap<ErlangTerm, ErlangTerm> map = new LinkedHashMap<ErlangTerm, ErlangTerm>(keysAndValues.length / 2);
        for (int index = 0; index < keysAndValues.length - 1; index += 2) {
            map.put(keysAndValues[index], keysAndValues[index + 1]);
        }
        return new ErlangMap(map);
    }

    private Erlang() {
    }
}

