/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;

public class ErlangTuple
extends ErlangTerm {
    private static final long serialVersionUID = -8441946894531062971L;
    private static final int MAX_SMALL_TUPLE_SIZE = 256;
    private final ErlangTerm[] elements;

    public ErlangTuple(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        int arity;
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        switch (this.getType()) {
            case SMALL_TUPLE: {
                arity = buffer.readByte();
                break;
            }
            case LARGE_TUPLE: {
                arity = buffer.readInt();
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
        this.elements = (ErlangTerm[])IntStream.range(0, arity).mapToObj(it -> ErlangTerm.newInstance(buffer)).toArray(ErlangTerm[]::new);
    }

    public ErlangTuple(ErlangTerm ... elements) {
        this(Arrays.asList(elements));
    }

    public ErlangTuple(Collection<ErlangTerm> adds) {
        if (adds.size() < 256) {
            this.setType(TermType.SMALL_TUPLE);
        } else {
            this.setType(TermType.LARGE_TUPLE);
        }
        this.elements = adds.toArray(new ErlangTerm[0]);
    }

    @Override
    public ErlangTuple asTuple() {
        return this;
    }

    @Override
    public Iterator<ErlangTerm> elements() {
        return Stream.of(this.elements).iterator();
    }

    @Override
    public ErlangTerm getUnsafe(int index) {
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        switch (this.getType()) {
            case SMALL_TUPLE: {
                buffer.writeByte(this.elements.length);
                break;
            }
            case LARGE_TUPLE: {
                buffer.writeInt(this.elements.length);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
        Stream.of(this.elements).forEachOrdered(it -> it.writeTo(buffer));
    }

    @SuppressFBWarnings(justification="generated code")
    public static ErlangTupleBuilder builder() {
        return new ErlangTupleBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangTuple(elements=" + Arrays.deepToString(this.elements) + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangTuple)) {
            return false;
        }
        ErlangTuple other = (ErlangTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.elements, other.elements);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangTuple;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.elements);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ErlangTupleBuilder {
        @SuppressFBWarnings(justification="generated code")
        private ArrayList<ErlangTerm> adds;

        @SuppressFBWarnings(justification="generated code")
        ErlangTupleBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangTupleBuilder add(ErlangTerm add) {
            if (this.adds == null) {
                this.adds = new ArrayList();
            }
            this.adds.add(add);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangTupleBuilder adds(Collection<? extends ErlangTerm> adds) {
            if (this.adds == null) {
                this.adds = new ArrayList();
            }
            this.adds.addAll(adds);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangTupleBuilder clearAdds() {
            if (this.adds != null) {
                this.adds.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangTuple build() {
            List<ErlangTerm> adds;
            switch (this.adds == null ? 0 : this.adds.size()) {
                case 0: {
                    adds = Collections.emptyList();
                    break;
                }
                case 1: {
                    adds = Collections.singletonList(this.adds.get(0));
                    break;
                }
                default: {
                    adds = Collections.unmodifiableList(new ArrayList<ErlangTerm>(this.adds));
                }
            }
            return new ErlangTuple(adds);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ErlangTuple.ErlangTupleBuilder(adds=" + this.adds + ")";
        }
    }
}

