/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.Erlang;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.type.ErlangInteger;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;

public class ErlangString
extends ErlangTerm {
    private static final long serialVersionUID = -606017265338010507L;
    private final String value;

    public ErlangString(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        short length = buffer.readShort();
        this.value = buffer.readCharSequence((int)length, StandardCharsets.ISO_8859_1).toString();
    }

    public ErlangString(String value) {
        this.value = value;
        if (value.length() > 65535 || !this.is8bitString()) {
            this.setType(TermType.LIST);
        } else {
            this.setType(TermType.STRING);
        }
    }

    @Override
    public String asText() {
        return this.value;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        int positionBefore = buffer.writerIndex() - 1;
        if (this.value.isEmpty()) {
            buffer.writerIndex(positionBefore);
            Erlang.NIL.writeTo(buffer);
            return;
        }
        int length = this.value.length();
        switch (this.getType()) {
            case STRING: {
                buffer.writeShort(length);
                buffer.writeCharSequence((CharSequence)this.value, StandardCharsets.ISO_8859_1);
                break;
            }
            case LIST: {
                ErlangTerm[] elements = (ErlangInteger[])this.value.codePoints().boxed().map(ErlangInteger::from).toArray(ErlangInteger[]::new);
                buffer.writerIndex(positionBefore);
                Erlang.list(elements).writeTo(buffer);
                break;
            }
            default: {
                buffer.writerIndex(positionBefore);
                Erlang.NIL.writeTo(buffer);
            }
        }
    }

    private boolean is8bitString() {
        return this.value.codePoints().allMatch(it -> it >= 0 && it <= 255);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangString(value=" + this.value + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangString)) {
            return false;
        }
        ErlangString other = (ErlangString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangString;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

