/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.common.NodeDescriptor;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.appulse.encon.terms.type.ErlangAtom;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.LongStream;
import lombok.NonNull;

public class ErlangReference
extends ErlangTerm {
    private static final long serialVersionUID = -868493639369161400L;
    private static final int MAX_REFERENCE_ARITY = 3;
    private NodeDescriptor descriptor;
    private final ErlangAtom node;
    private final long[] ids;
    private final int creation;

    public ErlangReference(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        switch (this.getType()) {
            case REFERENCE: {
                this.node = (ErlangAtom)ErlangTerm.newInstance(buffer);
                this.ids = new long[]{buffer.readInt() & 0x3FFFF};
                this.creation = buffer.readByte() & 3;
                return;
            }
            case NEW_REFERENCE: 
            case NEWER_REFERENCE: {
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
        short arity = buffer.readShort();
        if (arity > 3) {
            throw new IllegalArgumentException("Maximum arity value is 3, but was " + arity);
        }
        this.node = (ErlangAtom)ErlangTerm.newInstance(buffer);
        this.creation = this.getType() == TermType.NEW_REFERENCE ? buffer.readByte() & 3 : buffer.readInt();
        this.ids = LongStream.range(0L, arity).map(it -> (long)buffer.readInt() & 0xFFFFFFFFL).toArray();
        if (this.getType() == TermType.NEW_REFERENCE) {
            this.ids[0] = this.ids[0] & 0x3FFFFL;
        }
    }

    private ErlangReference(TermType type, @NonNull String node, long id, long[] ids, int creation) {
        super(Optional.ofNullable(type).orElse(TermType.NEW_REFERENCE));
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        this.node = new ErlangAtom(node);
        this.ids = Optional.ofNullable(ids).map(it -> (long[])it.clone()).map(it -> {
            long[] result = new long[]{0L, 0L, 0L};
            int length = ((long[])it).length > 3 ? 3 : ((long[])it).length;
            System.arraycopy(it, 0, result, 0, length);
            return result;
        }).orElseGet(() -> new long[]{id});
        switch (this.getType()) {
            case NEW_REFERENCE: {
                this.creation = creation & 3;
                this.ids[0] = this.ids[0] & 0x3FFFFL;
                break;
            }
            case REFERENCE: 
            case NEWER_REFERENCE: {
                this.creation = creation;
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
    }

    public long getId() {
        return this.ids[0];
    }

    @Override
    public String asText(String defaultValue) {
        return this.toString();
    }

    @Override
    public ErlangReference asReference() {
        return this;
    }

    public String toString() {
        return "#Reference<" + this.creation + '.' + this.ids[2] + '.' + this.ids[1] + '.' + this.ids[0] + '>';
    }

    public final NodeDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = NodeDescriptor.from((String)this.node.asText());
        }
        return this.descriptor;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        switch (this.getType()) {
            case REFERENCE: {
                this.node.writeTo(buffer);
                buffer.writeInt((int)this.ids[0] & 0x3FFFF);
                buffer.writeByte(this.creation);
                return;
            }
            case NEW_REFERENCE: 
            case NEWER_REFERENCE: {
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
        buffer.writeShort(this.ids.length);
        this.node.writeTo(buffer);
        switch (this.getType()) {
            case NEW_REFERENCE: {
                buffer.writeByte(this.creation);
                buffer.writeInt((int)this.ids[0] & 0x3FFFF);
                break;
            }
            default: {
                buffer.writeInt(this.creation);
                buffer.writeInt((int)this.ids[0]);
            }
        }
        LongStream.of(this.ids).skip(1L).forEachOrdered(it -> buffer.writeInt((int)it));
    }

    @SuppressFBWarnings(justification="generated code")
    public static ErlangReferenceBuilder builder() {
        return new ErlangReferenceBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public ErlangAtom getNode() {
        return this.node;
    }

    @SuppressFBWarnings(justification="generated code")
    public long[] getIds() {
        return this.ids;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCreation() {
        return this.creation;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangReference)) {
            return false;
        }
        ErlangReference other = (ErlangReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeDescriptor this$descriptor = this.getDescriptor();
        NodeDescriptor other$descriptor = other.getDescriptor();
        if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
            return false;
        }
        ErlangAtom this$node = this.getNode();
        ErlangAtom other$node = other.getNode();
        if (this$node == null ? other$node != null : !((Object)this$node).equals(other$node)) {
            return false;
        }
        if (!Arrays.equals(this.getIds(), other.getIds())) {
            return false;
        }
        return this.getCreation() == other.getCreation();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangReference;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeDescriptor $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        ErlangAtom $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : ((Object)$node).hashCode());
        result = result * 59 + Arrays.hashCode(this.getIds());
        result = result * 59 + this.getCreation();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ErlangReferenceBuilder {
        @SuppressFBWarnings(justification="generated code")
        private TermType type;
        @SuppressFBWarnings(justification="generated code")
        private String node;
        @SuppressFBWarnings(justification="generated code")
        private long id;
        @SuppressFBWarnings(justification="generated code")
        private long[] ids;
        @SuppressFBWarnings(justification="generated code")
        private int creation;

        @SuppressFBWarnings(justification="generated code")
        ErlangReferenceBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangReferenceBuilder type(TermType type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangReferenceBuilder node(String node) {
            this.node = node;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangReferenceBuilder id(long id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangReferenceBuilder ids(long[] ids) {
            this.ids = ids;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangReferenceBuilder creation(int creation) {
            this.creation = creation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangReference build() {
            return new ErlangReference(this.type, this.node, this.id, this.ids, this.creation);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ErlangReference.ErlangReferenceBuilder(type=" + (Object)((Object)this.type) + ", node=" + this.node + ", id=" + this.id + ", ids=" + Arrays.toString(this.ids) + ", creation=" + this.creation + ")";
        }
    }
}

