/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.ErlangTermDecodeException;
import io.appulse.encon.terms.type.ErlangInteger;
import io.netty.buffer.ByteBuf;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public class ErlangMap
extends ErlangTerm {
    private static final long serialVersionUID = -4889715199209923662L;
    private final LinkedHashMap<? extends ErlangTerm, ? extends ErlangTerm> map;

    public ErlangMap(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        IntFunction<ErlangTerm[]> mapFunction = it -> new ErlangTerm[]{ErlangTerm.newInstance(buffer), ErlangTerm.newInstance(buffer)};
        BinaryOperator mergeFunction = (left, right) -> {
            throw new ErlangTermDecodeException("Duplicate key " + left);
        };
        int arity = buffer.readInt();
        this.map = IntStream.range(0, arity).mapToObj(mapFunction).collect(Collectors.toMap(it -> it[0], it -> it[1], mergeFunction, LinkedHashMap::new));
    }

    public ErlangMap(@NonNull LinkedHashMap<? extends ErlangTerm, ? extends ErlangTerm> map) {
        super(TermType.MAP);
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        this.map = map;
    }

    @Override
    public ErlangMap asMap() {
        return this;
    }

    @Override
    public Iterator<ErlangTerm> elements() {
        return this.map.values().stream().map(it -> it).iterator();
    }

    @Override
    public Iterator<Map.Entry<ErlangTerm, ErlangTerm>> fields() {
        return this.map.entrySet().stream().map(it -> new AbstractMap.SimpleEntry(it.getKey(), it.getValue())).map(it -> it).iterator();
    }

    @Override
    public Iterator<ErlangTerm> fieldNames() {
        return this.map.keySet().stream().map(it -> it).iterator();
    }

    @Override
    public ErlangTerm getUnsafe(ErlangTerm term) {
        return this.map.get(term);
    }

    @Override
    public ErlangTerm getUnsafe(int index) {
        ErlangInteger term = new ErlangInteger(index);
        return this.map.get(term);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        buffer.writeInt(this.map.size());
        this.map.entrySet().forEach(it -> {
            ((ErlangTerm)it.getKey()).writeTo(buffer);
            ((ErlangTerm)it.getValue()).writeTo(buffer);
        });
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangMap(map=" + this.map + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangMap)) {
            return false;
        }
        ErlangMap other = (ErlangMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinkedHashMap<? extends ErlangTerm, ? extends ErlangTerm> this$map = this.map;
        LinkedHashMap<? extends ErlangTerm, ? extends ErlangTerm> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangMap;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LinkedHashMap<? extends ErlangTerm, ? extends ErlangTerm> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }
}

