/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.NonNull;

public class ErlangAtom
extends ErlangTerm {
    private static final long serialVersionUID = -2748345367418129439L;
    private static final byte[] TRUE_BYTES = Boolean.TRUE.toString().getBytes(StandardCharsets.UTF_8);
    private static final byte[] FALSE_BYTES = Boolean.FALSE.toString().getBytes(StandardCharsets.UTF_8);
    private static final int MAX_ATOM_CODE_POINTS_LENGTH = 255;
    private static final int MAX_SMALL_ATOM_BYTES_LENGTH = 255;
    private String value;
    private final byte[] bytes;
    private final transient Charset charset;

    public ErlangAtom(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        int length = type == TermType.SMALL_ATOM || type == TermType.SMALL_ATOM_UTF8 ? buffer.readUnsignedByte() : buffer.readUnsignedShort();
        this.charset = type == TermType.SMALL_ATOM_UTF8 || type == TermType.ATOM_UTF8 ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        this.bytes = new byte[length];
        buffer.readBytes(this.bytes);
    }

    public ErlangAtom(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.value = value.codePointCount(0, value.length()) <= 255 ? value : new String(value.codePoints().toArray(), 0, 255);
        this.charset = StandardCharsets.UTF_8;
        this.bytes = this.value.getBytes(this.charset);
        if (this.bytes.length > 255) {
            this.setType(TermType.ATOM_UTF8);
        } else {
            this.setType(TermType.SMALL_ATOM_UTF8);
        }
    }

    public ErlangAtom(boolean value) {
        super(TermType.SMALL_ATOM_UTF8);
        this.charset = StandardCharsets.UTF_8;
        this.value = Boolean.toString(value);
        this.bytes = value ? TRUE_BYTES : FALSE_BYTES;
    }

    @Override
    public boolean isBoolean() {
        return "true".equalsIgnoreCase(this.asText()) || "false".equalsIgnoreCase(this.asText());
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return "true".equalsIgnoreCase(this.asText());
    }

    @Override
    public String asText(String defaultValue) {
        if (this.value == null) {
            this.value = new String(this.bytes, this.charset);
        }
        return this.value;
    }

    @Override
    public byte[] asBinary(byte[] defaultValue) {
        return (byte[])this.bytes.clone();
    }

    @Override
    public ErlangAtom asAtom() {
        return this;
    }

    @Override
    public boolean isTextual() {
        return true;
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        switch (this.getType()) {
            case SMALL_ATOM_UTF8: {
                buffer.writeByte(this.bytes.length);
                break;
            }
            case ATOM_UTF8: {
                buffer.writeShort(this.bytes.length);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
        buffer.writeBytes(this.bytes);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangAtom(value=" + this.value + ", bytes=" + Arrays.toString(this.bytes) + ", charset=" + this.charset + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangAtom)) {
            return false;
        }
        ErlangAtom other = (ErlangAtom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangAtom;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.bytes);
        return result;
    }
}

