/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.term;

import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.term.ValueTerm;
import io.appulse.encon.terms.type.ErlangAtom;
import io.appulse.encon.terms.type.ErlangList;
import io.appulse.encon.terms.type.ErlangMap;
import io.appulse.encon.terms.type.ErlangTuple;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public interface CollectionTerm
extends ValueTerm,
Iterable<ErlangTerm> {
    default public boolean isCollectionTerm() {
        switch (this.getType()) {
            case MAP: 
            case LIST: 
            case SMALL_TUPLE: 
            case LARGE_TUPLE: {
                return true;
            }
        }
        return false;
    }

    default public boolean isList() {
        return this.getType() == TermType.LIST;
    }

    default public ErlangList asList() {
        return null;
    }

    default public boolean isTuple() {
        return this.getType() == TermType.SMALL_TUPLE || this.getType() == TermType.LARGE_TUPLE;
    }

    default public ErlangTuple asTuple() {
        return null;
    }

    default public boolean isMap() {
        return this.getType() == TermType.MAP;
    }

    default public ErlangMap asMap() {
        return null;
    }

    default public int size() {
        return 1;
    }

    default public Optional<ErlangTerm> get(int index) {
        if (index < 0 || index >= this.size()) {
            return Optional.empty();
        }
        ErlangTerm result = this.getUnsafe(index);
        return Optional.ofNullable(result);
    }

    default public ErlangTerm getUnsafe(int index) {
        return index == 0 ? (ErlangTerm)this : null;
    }

    default public Optional<ErlangTerm> getByAtom(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        ErlangAtom term = new ErlangAtom(fieldName);
        return this.get(term);
    }

    default public Optional<ErlangTerm> get(@NonNull ErlangTerm term) {
        if (term == null) {
            throw new NullPointerException("term is marked @NonNull but is null");
        }
        ErlangTerm result = this.getUnsafe(term);
        return Optional.ofNullable(result);
    }

    default public ErlangTerm getUnsafe(ErlangTerm term) {
        return null;
    }

    default public boolean hasNonNil(ErlangTerm term) {
        return this.get(term).map(it -> !it.isNil()).orElse(false);
    }

    default public boolean hasNonNilByAtom(String fieldName) {
        return this.getByAtom(fieldName).map(it -> !it.isNil()).orElse(false);
    }

    default public boolean hasNonNil(int index) {
        return this.get(index).map(it -> !it.isNil()).orElse(false);
    }

    @Override
    default public Iterator<ErlangTerm> iterator() {
        return this.elements();
    }

    default public Iterator<ErlangTerm> elements() {
        return Collections.emptyIterator();
    }

    default public Iterator<Map.Entry<ErlangTerm, ErlangTerm>> fields() {
        return Collections.emptyIterator();
    }

    default public Iterator<ErlangTerm> fieldNames() {
        return Collections.emptyIterator();
    }
}

