/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.Erlang;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.ErlangTermDecodeException;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.appulse.encon.terms.term.BooleanTerm;
import io.appulse.encon.terms.term.CollectionTerm;
import io.appulse.encon.terms.term.FloatTerm;
import io.appulse.encon.terms.term.IntegerTerm;
import io.appulse.encon.terms.term.NodeContainerTerm;
import io.appulse.encon.terms.term.StringTerm;
import io.appulse.encon.terms.type.ErlangAtom;
import io.appulse.encon.terms.type.ErlangBinary;
import io.appulse.encon.terms.type.ErlangBitString;
import io.appulse.encon.terms.type.ErlangExternalFunction;
import io.appulse.encon.terms.type.ErlangFloat;
import io.appulse.encon.terms.type.ErlangFunction;
import io.appulse.encon.terms.type.ErlangInteger;
import io.appulse.encon.terms.type.ErlangList;
import io.appulse.encon.terms.type.ErlangMap;
import io.appulse.encon.terms.type.ErlangPid;
import io.appulse.encon.terms.type.ErlangPort;
import io.appulse.encon.terms.type.ErlangReference;
import io.appulse.encon.terms.type.ErlangString;
import io.appulse.encon.terms.type.ErlangTuple;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.Serializable;
import lombok.NonNull;

public abstract class ErlangTerm
implements IntegerTerm,
FloatTerm,
BooleanTerm,
StringTerm,
CollectionTerm,
NodeContainerTerm,
Serializable {
    private static final long serialVersionUID = 5430854281567501819L;
    private TermType type;

    public static <T extends ErlangTerm> T newInstance(@NonNull ByteBuf buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        byte typeByte = buffer.readByte();
        TermType type = TermType.of(typeByte);
        switch (type) {
            case SMALL_INTEGER: 
            case INTEGER: 
            case SMALL_BIG: 
            case LARGE_BIG: {
                return (T)new ErlangInteger(type, buffer);
            }
            case FLOAT: 
            case NEW_FLOAT: {
                return (T)new ErlangFloat(type, buffer);
            }
            case REFERENCE: 
            case NEW_REFERENCE: 
            case NEWER_REFERENCE: {
                return (T)new ErlangReference(type, buffer);
            }
            case PORT: 
            case NEW_PORT: {
                return (T)new ErlangPort(type, buffer);
            }
            case PID: 
            case NEW_PID: {
                return (T)new ErlangPid(type, buffer);
            }
            case SMALL_TUPLE: 
            case LARGE_TUPLE: {
                return (T)new ErlangTuple(type, buffer);
            }
            case MAP: {
                return (T)new ErlangMap(type, buffer);
            }
            case NIL: {
                return (T)Erlang.NIL;
            }
            case STRING: {
                return (T)new ErlangString(type, buffer);
            }
            case LIST: {
                return (T)new ErlangList(type, buffer);
            }
            case BINARY: {
                return (T)new ErlangBinary(type, buffer);
            }
            case FUNCTION: 
            case NEW_FUNCTION: {
                return (T)new ErlangFunction(type, buffer);
            }
            case EXTERNAL_FUNCTION: {
                return (T)new ErlangExternalFunction(type, buffer);
            }
            case BIT_BINNARY: {
                return (T)new ErlangBitString(type, buffer);
            }
            case ATOM_UTF8: 
            case SMALL_ATOM_UTF8: 
            case ATOM: 
            case SMALL_ATOM: {
                return (T)new ErlangAtom(type, buffer);
            }
        }
        String message = String.format("Unknown term type %s (%d)", type.name(), typeByte);
        throw new ErlangTermDecodeException(message);
    }

    protected ErlangTerm() {
        this.type = TermType.UNKNOWN;
    }

    protected ErlangTerm(@NonNull TermType type) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        if (!this.getClass().equals(type.getType())) {
            throw new IllegalErlangTermTypeException(this.getClass(), type);
        }
        this.type = type;
    }

    public byte[] toBytes() {
        ByteBuf buffer = Unpooled.buffer();
        this.writeTo(buffer);
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        return bytes;
    }

    public void writeTo(@NonNull ByteBuf buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        buffer.writeByte((int)this.type.getCode());
        this.serialize(buffer);
    }

    protected abstract void serialize(ByteBuf var1);

    @Override
    @SuppressFBWarnings(justification="generated code")
    public TermType getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangTerm)) {
            return false;
        }
        ErlangTerm other = (ErlangTerm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TermType this$type = this.getType();
        TermType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangTerm;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TermType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    protected void setType(TermType type) {
        this.type = type;
    }
}

