/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.Erlang;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.appulse.encon.terms.exception.IllegalErlangTermTypeException;
import io.appulse.encon.terms.type.ErlangAtom;
import io.appulse.encon.terms.type.ErlangInteger;
import io.appulse.encon.terms.type.ErlangPid;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;

public class ErlangFunction
extends ErlangTerm {
    private static final long serialVersionUID = 6531209051661233549L;
    private final ErlangPid pid;
    private final String module;
    private final int index;
    private final int unique;
    private final ErlangTerm[] variables;
    private int arity;
    private byte[] md5;
    private int oldIndex;

    public ErlangFunction(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        int freeVariablesCount = 0;
        if (type == TermType.FUNCTION) {
            freeVariablesCount = buffer.readInt();
            this.pid = (ErlangPid)ErlangTerm.newInstance(buffer);
            ErlangAtom atomModule = (ErlangAtom)ErlangTerm.newInstance(buffer);
            this.module = atomModule.asText();
            ErlangInteger numberIndex = (ErlangInteger)ErlangTerm.newInstance(buffer);
            this.index = numberIndex.asInt();
            ErlangInteger numberUnique = (ErlangInteger)ErlangTerm.newInstance(buffer);
            this.unique = numberUnique.asInt();
        } else if (type == TermType.NEW_FUNCTION) {
            buffer.readInt();
            this.arity = buffer.readByte();
            this.md5 = new byte[16];
            buffer.readBytes(this.md5);
            this.index = buffer.readInt();
            freeVariablesCount = buffer.readInt();
            ErlangAtom atomModule = (ErlangAtom)ErlangTerm.newInstance(buffer);
            this.module = atomModule.asText();
            ErlangInteger numberOldIndex = (ErlangInteger)ErlangTerm.newInstance(buffer);
            this.oldIndex = numberOldIndex.asInt();
            ErlangInteger numberUnique = (ErlangInteger)ErlangTerm.newInstance(buffer);
            this.unique = numberUnique.asInt();
            this.pid = (ErlangPid)ErlangTerm.newInstance(buffer);
        } else {
            throw new IllegalErlangTermTypeException(this.getClass(), type);
        }
        this.variables = (ErlangTerm[])IntStream.range(0, freeVariablesCount).mapToObj(it -> ErlangTerm.newInstance(buffer)).toArray(ErlangTerm[]::new);
    }

    private ErlangFunction(ErlangPid pid, String module, int index, int unique, ErlangTerm[] variables, int arity, byte[] md5, int oldIndex) {
        super(md5 == null ? TermType.FUNCTION : TermType.NEW_FUNCTION);
        this.pid = pid;
        this.module = module;
        this.index = index;
        this.unique = unique;
        this.arity = arity;
        this.oldIndex = oldIndex;
        this.variables = Optional.ofNullable(variables).map(it -> (ErlangTerm[])it.clone()).orElse(null);
        this.md5 = Optional.ofNullable(md5).map(it -> (byte[])it.clone()).orElse(null);
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        switch (this.getType()) {
            case FUNCTION: {
                buffer.writeInt(this.variables.length);
                this.pid.writeTo(buffer);
                Erlang.atom(this.module).writeTo(buffer);
                Erlang.number(this.index).writeTo(buffer);
                Erlang.number(this.unique).writeTo(buffer);
                Stream.of(this.variables).forEach(it -> it.writeTo(buffer));
                break;
            }
            case NEW_FUNCTION: {
                int position1 = buffer.writerIndex();
                buffer.writeInt(-1);
                buffer.writeByte(this.arity);
                buffer.writeBytes(this.md5);
                buffer.writeInt(this.index);
                buffer.writeInt(this.variables.length);
                Erlang.atom(this.module).writeTo(buffer);
                Erlang.number(this.oldIndex).writeTo(buffer);
                Erlang.number(this.unique).writeTo(buffer);
                this.pid.writeTo(buffer);
                Stream.of(this.variables).forEach(it -> it.writeTo(buffer));
                int position2 = buffer.writerIndex();
                buffer.writerIndex(position1);
                buffer.writeInt(position2 - position1);
                buffer.writerIndex(position2 + 4);
                break;
            }
            default: {
                throw new IllegalErlangTermTypeException(this.getClass(), this.getType());
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public static ErlangFunctionBuilder builder() {
        return new ErlangFunctionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public ErlangPid getPid() {
        return this.pid;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getModule() {
        return this.module;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getIndex() {
        return this.index;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getUnique() {
        return this.unique;
    }

    @SuppressFBWarnings(justification="generated code")
    public ErlangTerm[] getVariables() {
        return this.variables;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getArity() {
        return this.arity;
    }

    @SuppressFBWarnings(justification="generated code")
    public byte[] getMd5() {
        return this.md5;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getOldIndex() {
        return this.oldIndex;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangFunction(pid=" + this.getPid() + ", module=" + this.getModule() + ", index=" + this.getIndex() + ", unique=" + this.getUnique() + ", variables=" + Arrays.deepToString(this.getVariables()) + ", arity=" + this.getArity() + ", md5=" + Arrays.toString(this.getMd5()) + ", oldIndex=" + this.getOldIndex() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangFunction)) {
            return false;
        }
        ErlangFunction other = (ErlangFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ErlangPid this$pid = this.getPid();
        ErlangPid other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getUnique() != other.getUnique()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVariables(), other.getVariables())) {
            return false;
        }
        if (this.getArity() != other.getArity()) {
            return false;
        }
        if (!Arrays.equals(this.getMd5(), other.getMd5())) {
            return false;
        }
        return this.getOldIndex() == other.getOldIndex();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangFunction;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ErlangPid $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getUnique();
        result = result * 59 + Arrays.deepHashCode(this.getVariables());
        result = result * 59 + this.getArity();
        result = result * 59 + Arrays.hashCode(this.getMd5());
        result = result * 59 + this.getOldIndex();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class ErlangFunctionBuilder {
        @SuppressFBWarnings(justification="generated code")
        private ErlangPid pid;
        @SuppressFBWarnings(justification="generated code")
        private String module;
        @SuppressFBWarnings(justification="generated code")
        private int index;
        @SuppressFBWarnings(justification="generated code")
        private int unique;
        @SuppressFBWarnings(justification="generated code")
        private ErlangTerm[] variables;
        @SuppressFBWarnings(justification="generated code")
        private int arity;
        @SuppressFBWarnings(justification="generated code")
        private byte[] md5;
        @SuppressFBWarnings(justification="generated code")
        private int oldIndex;

        @SuppressFBWarnings(justification="generated code")
        ErlangFunctionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder pid(ErlangPid pid) {
            this.pid = pid;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder module(String module) {
            this.module = module;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder index(int index) {
            this.index = index;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder unique(int unique) {
            this.unique = unique;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder variables(ErlangTerm[] variables) {
            this.variables = variables;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder arity(int arity) {
            this.arity = arity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder md5(byte[] md5) {
            this.md5 = md5;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunctionBuilder oldIndex(int oldIndex) {
            this.oldIndex = oldIndex;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErlangFunction build() {
            return new ErlangFunction(this.pid, this.module, this.index, this.unique, this.variables, this.arity, this.md5, this.oldIndex);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ErlangFunction.ErlangFunctionBuilder(pid=" + this.pid + ", module=" + this.module + ", index=" + this.index + ", unique=" + this.unique + ", variables=" + Arrays.deepToString(this.variables) + ", arity=" + this.arity + ", md5=" + Arrays.toString(this.md5) + ", oldIndex=" + this.oldIndex + ")";
        }
    }
}

