/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.terms.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.TermType;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import lombok.NonNull;

public class ErlangBinary
extends ErlangTerm {
    private static final long serialVersionUID = 2120051138040192507L;
    private final byte[] bytes;

    public ErlangBinary(TermType type, @NonNull ByteBuf buffer) {
        super(type);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        int length = buffer.readInt();
        this.bytes = new byte[length];
        buffer.readBytes(this.bytes);
    }

    public ErlangBinary(@NonNull byte[] bytes) {
        super(TermType.BINARY);
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    @Override
    public byte[] asBinary(byte[] defaultValue) {
        return (byte[])this.bytes.clone();
    }

    @Override
    protected void serialize(ByteBuf buffer) {
        buffer.writeInt(this.bytes.length);
        buffer.writeBytes(this.bytes);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ErlangBinary(bytes=" + Arrays.toString(this.bytes) + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErlangBinary)) {
            return false;
        }
        ErlangBinary other = (ErlangBinary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ErlangBinary;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.bytes);
        return result;
    }
}

