/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.Node;
import io.appulse.encon.Nodes;
import io.appulse.encon.mailbox.Mailbox;
import io.appulse.encon.spring.EnconAutoConfiguration;
import io.appulse.encon.spring.ErlangMailbox;
import io.appulse.utils.AnnotationUtils;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;

class BeanPostProcessorErlangMailboxAnnotation
implements BeanPostProcessor,
Ordered {
    @NonNull
    private final Nodes nodes;
    @NonNull
    private final Node defaultNode;
    @Autowired
    private final AbstractApplicationContext context;

    public int getOrder() {
        return 100;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Optional annotation = AnnotationUtils.findAnnotation(bean.getClass(), ErlangMailbox.class);
        if (!annotation.isPresent()) {
            return bean;
        }
        Node node = annotation.map(ErlangMailbox::node).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).map(it -> this.nodes.node(it).orElseGet(() -> this.nodes.newNode(it))).map(this::registerIfNotExist).orElse(this.defaultNode);
        Mailbox mailbox = annotation.map(ErlangMailbox::name).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).map(it -> Optional.ofNullable(node.mailbox(it)).orElseGet(() -> node.mailbox().name(it).build())).map(this::registerIfNotExist).orElseGet(() -> this.createAndRegisterNewMailbox(node));
        EnconAutoConfiguration.MailboxOperationsConfiguration.registerMailboxOperations(mailbox, this.context.getBeanFactory());
        return bean;
    }

    private Node registerIfNotExist(Node node) {
        return this.registerIfNotExist(node.getDescriptor().getNodeName(), node);
    }

    private Mailbox registerIfNotExist(Mailbox mailbox) {
        return this.registerIfNotExist(mailbox.getName(), mailbox);
    }

    private <T> T registerIfNotExist(String name, T bean) {
        ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
        if (!beanFactory.containsBean(name)) {
            beanFactory.registerSingleton(name, bean);
        }
        return bean;
    }

    private Mailbox createAndRegisterNewMailbox(Node node) {
        String mailboxBeanName = node.getDescriptor().getNodeName() + "Mailbox";
        ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
        if (beanFactory.containsBean(mailboxBeanName)) {
            throw new IllegalArgumentException();
        }
        Mailbox newMailbox = node.mailbox().build();
        beanFactory.registerSingleton(mailboxBeanName, (Object)newMailbox);
        return newMailbox;
    }

    @SuppressFBWarnings(justification="generated code")
    public BeanPostProcessorErlangMailboxAnnotation(@NonNull Nodes nodes, @NonNull Node defaultNode, AbstractApplicationContext context) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked @NonNull but is null");
        }
        if (defaultNode == null) {
            throw new NullPointerException("defaultNode is marked @NonNull but is null");
        }
        this.nodes = nodes;
        this.defaultNode = defaultNode;
        this.context = context;
    }
}

