/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.Node;
import io.appulse.encon.common.NodeDescriptor;
import io.appulse.encon.common.RemoteNode;
import io.appulse.encon.connection.regular.Message;
import io.appulse.encon.databind.TermMapper;
import io.appulse.encon.mailbox.Mailbox;
import io.appulse.encon.terms.ErlangTerm;
import io.appulse.encon.terms.type.ErlangPid;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MailboxOperations {
    @NonNull
    private final Mailbox self;

    static String generateName(Node node) {
        return node.getDescriptor().getNodeName() + "MailboxOperations";
    }

    static String generateName(Mailbox mailbox) {
        String name = mailbox.getName();
        if (name == null || name.isEmpty()) {
            return MailboxOperations.generateName(mailbox.getNode());
        }
        return mailbox.getNode().getDescriptor().getNodeName() + '_' + name + "MailboxOperations";
    }

    public String name() {
        return this.self.getName();
    }

    public ErlangPid pid() {
        return this.self.getPid();
    }

    public Node node() {
        return this.self.getNode();
    }

    public void send(@NonNull ErlangPid to, @NonNull Object object) {
        if (to == null) {
            throw new NullPointerException("to is marked @NonNull but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        ErlangTerm term = TermMapper.serialize((Object)object);
        this.self.send(to, term);
    }

    public void send(@NonNull String mailbox, @NonNull Object object) {
        if (mailbox == null) {
            throw new NullPointerException("mailbox is marked @NonNull but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        ErlangTerm term = TermMapper.serialize((Object)object);
        this.self.send(mailbox, term);
    }

    public void send(@NonNull String node, @NonNull String mailbox, @NonNull Object object) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        if (mailbox == null) {
            throw new NullPointerException("mailbox is marked @NonNull but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        ErlangTerm term = TermMapper.serialize((Object)object);
        this.self.send(node, mailbox, term);
    }

    public void send(@NonNull NodeDescriptor descriptor, @NonNull String mailbox, @NonNull Object object) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked @NonNull but is null");
        }
        if (mailbox == null) {
            throw new NullPointerException("mailbox is marked @NonNull but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        ErlangTerm term = TermMapper.serialize((Object)object);
        this.self.send(descriptor, mailbox, term);
    }

    public void send(@NonNull RemoteNode remote, @NonNull String mailbox, @NonNull Object object) {
        if (remote == null) {
            throw new NullPointerException("remote is marked @NonNull but is null");
        }
        if (mailbox == null) {
            throw new NullPointerException("mailbox is marked @NonNull but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        ErlangTerm term = TermMapper.serialize((Object)object);
        this.self.send(remote, mailbox, term);
    }

    public ErlangTerm receive() {
        return this.self.receive().getBody();
    }

    public Optional<ErlangTerm> receive(long timeout, TimeUnit unit) {
        return Optional.ofNullable(this.self.receive(timeout, unit)).map(Message::getBody);
    }

    public <T> T receive(Class<T> type) {
        ErlangTerm term = this.receive();
        return (T)TermMapper.deserialize((ErlangTerm)term, type);
    }

    public <T> Optional<T> receive(Class<T> type, long timeout, TimeUnit unit) {
        return this.receive(timeout, unit).map(it -> TermMapper.deserialize((ErlangTerm)it, (Class)type));
    }

    @SuppressFBWarnings(justification="generated code")
    public static MailboxOperationsBuilder builder() {
        return new MailboxOperationsBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public MailboxOperations(@NonNull Mailbox self) {
        if (self == null) {
            throw new NullPointerException("self is marked @NonNull but is null");
        }
        this.self = self;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class MailboxOperationsBuilder {
        @SuppressFBWarnings(justification="generated code")
        private Mailbox self;

        @SuppressFBWarnings(justification="generated code")
        MailboxOperationsBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public MailboxOperationsBuilder self(Mailbox self) {
            this.self = self;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public MailboxOperations build() {
            return new MailboxOperations(this.self);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "MailboxOperations.MailboxOperationsBuilder(self=" + this.self + ")";
        }
    }
}

