/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.config.Config;
import io.appulse.encon.config.Defaults;
import io.appulse.encon.config.NodeConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Validated
@ConfigurationProperties(prefix="spring.encon")
public class EnconProperties {
    private final AtomicReference<Object> config = new AtomicReference();
    private Boolean enabled;
    private Defaults defaults;
    @NonNull
    private Map<String, NodeConfig> nodes = new LinkedHashMap<String, NodeConfig>();

    @PostConstruct
    public void postConstruct() {
        if (this.enabled == null) {
            this.enabled = Boolean.TRUE;
        }
        if (this.defaults == null) {
            this.defaults = Defaults.INSTANCE;
        }
    }

    private Config createConfig() {
        return Config.builder().defaults(this.defaults).nodes(this.nodes).build();
    }

    @SuppressFBWarnings(justification="generated code")
    public EnconProperties() {
    }

    @SuppressFBWarnings(justification="generated code")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    public Defaults getDefaults() {
        return this.defaults;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public Map<String, NodeConfig> getNodes() {
        return this.nodes;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setDefaults(Defaults defaults) {
        this.defaults = defaults;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setNodes(@NonNull Map<String, NodeConfig> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked @NonNull but is null");
        }
        this.nodes = nodes;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnconProperties)) {
            return false;
        }
        EnconProperties other = (EnconProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Defaults this$defaults = this.getDefaults();
        Defaults other$defaults = other.getDefaults();
        if (this$defaults == null ? other$defaults != null : !this$defaults.equals(other$defaults)) {
            return false;
        }
        Map<String, NodeConfig> this$nodes = this.getNodes();
        Map<String, NodeConfig> other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof EnconProperties;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Defaults $defaults = this.getDefaults();
        result = result * 59 + ($defaults == null ? 43 : $defaults.hashCode());
        Map<String, NodeConfig> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "EnconProperties(config=" + this.getConfig() + ", enabled=" + this.getEnabled() + ", defaults=" + this.getDefaults() + ", nodes=" + this.getNodes() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="generated code")
    Config getConfig() {
        Object value = this.config.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.config;
            synchronized (atomicReference) {
                value = this.config.get();
                if (value == null) {
                    Config actualValue = this.createConfig();
                    value = actualValue == null ? this.config : actualValue;
                    this.config.set(value);
                }
            }
        }
        return (Config)(value == this.config ? null : value);
    }
}

