/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import io.appulse.encon.Node;
import io.appulse.encon.Nodes;
import io.appulse.encon.common.NodeDescriptor;
import io.appulse.encon.config.Config;
import io.appulse.encon.databind.TermMapper;
import io.appulse.encon.handler.mailbox.MailboxHandler;
import io.appulse.encon.mailbox.Mailbox;
import io.appulse.encon.spring.BeanPostProcessorErlangMailboxAnnotation;
import io.appulse.encon.spring.BeanPostProcessorInjectMailboxAnnotation;
import io.appulse.encon.spring.BeanPostProcessorMailboxHandler;
import io.appulse.encon.spring.EnconProperties;
import io.appulse.encon.spring.MailboxOperations;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.AbstractApplicationContext;

@Configuration
@ConditionalOnClass(value={Node.class, MailboxHandler.class, TermMapper.class})
@ConditionalOnProperty(value={"spring.encon.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={EnconProperties.class})
@AutoConfigureBefore(value={MailboxOperationsConfiguration.class})
class EnconAutoConfiguration {
    @Autowired
    private EnconProperties enconProperties;
    @Autowired
    private AbstractApplicationContext context;

    EnconAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public Config defaultConfig() {
        return this.enconProperties.getConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public Nodes defaultEnconNodes(Config config) {
        Nodes nodes = Nodes.start((Config)config);
        for (Node node : nodes) {
            NodeDescriptor descriptor = node.getDescriptor();
            String name = descriptor.getNodeName();
            ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
            beanFactory.registerSingleton(name, (Object)node);
            node.mailboxes().values().stream().filter(it -> it.getName() != null && !it.getName().isEmpty()).filter(it -> !"net_kernel".equalsIgnoreCase(it.getName())).forEach(it -> {
                String mailboxName = name + '_' + it.getName() + "Mailbox";
                beanFactory.registerSingleton(mailboxName, it);
            });
        }
        return nodes;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public Node defaultEnconNode(Nodes nodes) {
        Collection collection = nodes.nodes();
        return collection.isEmpty() ? nodes.newNode("encon") : (Node)collection.iterator().next();
    }

    @Bean
    public BeanPostProcessorErlangMailboxAnnotation beanPostProcessorErlangMailboxAnnotation(Nodes nodes, Node defaultNode) {
        return new BeanPostProcessorErlangMailboxAnnotation(nodes, defaultNode, this.context);
    }

    @Bean
    public BeanPostProcessorInjectMailboxAnnotation beanPostProcessorInjectMailboxAnnotation(Nodes nodes, Node defaultNode) {
        return new BeanPostProcessorInjectMailboxAnnotation(nodes, defaultNode, this.context);
    }

    @Bean
    public BeanPostProcessorMailboxHandler beanPostProcessorMailboxHandler(Nodes nodes, Node defaultNode) {
        return new BeanPostProcessorMailboxHandler(nodes, defaultNode);
    }

    @Configuration
    @ConditionalOnBean(value={Node.class})
    public static class MailboxOperationsConfiguration {
        @Autowired
        Collection<Node> nodes;
        @Autowired
        AbstractApplicationContext context;

        public static void registerMailboxOperations(Mailbox mailbox, ConfigurableListableBeanFactory beanFactory) {
            String name = MailboxOperations.generateName(mailbox);
            if (beanFactory.containsBean(name)) {
                return;
            }
            MailboxOperations mailboxOperations = MailboxOperations.builder().self(mailbox).build();
            beanFactory.registerSingleton(name, (Object)mailboxOperations);
        }

        @PostConstruct
        void postConstruct() {
            this.nodes.stream().map(Node::mailboxes).map(Map::values).flatMap(Collection::stream).filter(Objects::nonNull).filter(it -> !"net_kernel".equalsIgnoreCase(it.getName())).forEach(this::registerMailboxOperations);
        }

        private void registerMailboxOperations(Mailbox mailbox) {
            MailboxOperationsConfiguration.registerMailboxOperations(mailbox, this.context.getBeanFactory());
        }
    }
}

