/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import io.appulse.encon.databind.annotation.AsErlangList;
import io.appulse.encon.databind.annotation.AsErlangTuple;
import io.appulse.encon.spring.MatchingCaseMapping;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

enum MessageWrapper {
    TUPLE,
    LIST,
    NONE,
    UNDEFINED;


    static MessageWrapper from(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return Optional.of(MatchingCaseMapping.class).map(method::getAnnotation).filter(Objects::nonNull).map(MatchingCaseMapping::value).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).map(MessageWrapper::guessByString).orElseGet(() -> Optional.of(method).map(MessageWrapper::guessByArguments).filter(it -> it != UNDEFINED).orElse(TUPLE));
    }

    static MessageWrapper guessByArguments(Method method) {
        if (method.getParameterCount() == 1) {
            Class<?> parameterType = method.getParameterTypes()[0];
            if (parameterType.isAnnotationPresent(AsErlangTuple.class)) {
                return TUPLE;
            }
            if (parameterType.isAnnotationPresent(AsErlangList.class)) {
                return LIST;
            }
        }
        return UNDEFINED;
    }

    static MessageWrapper guessByString(String str) {
        if (str == null) {
            return NONE;
        }
        String trimmed = str.trim();
        if (trimmed.isEmpty()) {
            return NONE;
        }
        switch (trimmed.charAt(0)) {
            case '{': {
                return TUPLE;
            }
            case '[': {
                return LIST;
            }
        }
        return UNDEFINED;
    }
}

