/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.databind.annotation.AsErlangList;
import io.appulse.encon.databind.annotation.AsErlangTuple;
import io.appulse.encon.databind.annotation.IgnoreField;
import io.appulse.encon.handler.message.matcher.Matchers;
import io.appulse.encon.spring.MatchingCaseMapping;
import io.appulse.encon.spring.MessageWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

final class ControllerMethodDescriptor {
    @NonNull
    private final Method method;
    @NonNull
    private final Object[] patternArguments;
    @NonNull
    private final MessageWrapper wrapper;

    static ControllerMethodDescriptor of(Method method) {
        MessageWrapper wrapper = MessageWrapper.from(method);
        Object[] arguments = ControllerMethodDescriptor.createArguments(method, wrapper);
        return new ControllerMethodDescriptor(method, arguments, wrapper);
    }

    private static Object[] createArguments(Method method, MessageWrapper wrapper) {
        Class<?> type;
        if (method.getParameterCount() == 1 && ((type = method.getParameterTypes()[0]).isAnnotationPresent(AsErlangList.class) || type.isAnnotationPresent(AsErlangTuple.class))) {
            return Stream.of(type.getDeclaredFields()).filter(it -> !it.isAnnotationPresent(IgnoreField.class)).map(Field::getType).map(it -> Matchers.any()).toArray(Object[]::new);
        }
        String[] arguments = Optional.of(MatchingCaseMapping.class).map(method::getAnnotation).filter(Objects::nonNull).map(MatchingCaseMapping::value).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).map(it -> wrapper == MessageWrapper.NONE ? it : it.substring(1, it.length() - 1)).map(it -> (String[])Stream.of(it.split("(,\\s*|\\s+)")).map(String::trim).toArray(String[]::new)).filter(it -> ((String[])it).length == 0).orElseGet(() -> ControllerMethodDescriptor.unwrap(method).orElseGet(() -> (String[])Stream.of(method.getParameters()).map(it -> "*").toArray(String[]::new)));
        return Stream.of(arguments).map(ControllerMethodDescriptor::createArgument).toArray(Object[]::new);
    }

    private static Object createArgument(String str) {
        switch (str) {
            case "*": 
            case "_": 
            case "any": {
                return Matchers.any();
            }
            case "anyBoolean": {
                return Matchers.anyBoolean();
            }
            case "anyByte": {
                return Matchers.anyByte();
            }
            case "anyChar": {
                return Character.valueOf(Matchers.anyChar());
            }
            case "anyShort": {
                return Matchers.anyShort();
            }
            case "anyInt": {
                return Matchers.anyInt();
            }
            case "anyLong": {
                return Matchers.anyLong();
            }
            case "anyFloat": {
                return Float.valueOf(Matchers.anyFloat());
            }
            case "anyDouble": {
                return Matchers.anyDouble();
            }
            case "anyString": {
                return Matchers.anyString();
            }
            case "anyList": {
                return Matchers.anyList();
            }
            case "anySet": {
                return Matchers.anySet();
            }
            case "anyMap": {
                return Matchers.anyMap();
            }
            case "anyCollection": {
                return Matchers.anyCollection();
            }
            case "anyIterable": {
                return Matchers.anyIterable();
            }
        }
        if (str.charAt(0) == ':') {
            return Matchers.eq((Object)ControllerMethodDescriptor.unwrapString(str.substring(1)));
        }
        Integer intValue = ControllerMethodDescriptor.getInteger(str);
        if (intValue != null) {
            return Matchers.eq((Object)intValue);
        }
        Double doubleValue = ControllerMethodDescriptor.getDouble(str);
        if (doubleValue != null) {
            return Matchers.eq((Object)doubleValue);
        }
        return Matchers.eq((Object)ControllerMethodDescriptor.unwrapString(str));
    }

    private static Integer getInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static Double getDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String unwrapString(String string) {
        char firstChar = string.charAt(0);
        return firstChar == '\'' || firstChar == '\"' ? string.substring(1, string.length() - 1) : string;
    }

    private static Optional<String[]> unwrap(Method method) {
        if (method.getParameterCount() != 1) {
            return Optional.empty();
        }
        Class<?> type = method.getParameterTypes()[0];
        if (!type.isAnnotationPresent(AsErlangList.class) && !type.isAnnotationPresent(AsErlangTuple.class)) {
            return Optional.empty();
        }
        return Optional.of(type.getDeclaredFields()).map(fields -> (String[])Stream.of(fields).filter(it -> !it.isSynthetic()).filter(it -> !it.isAnnotationPresent(IgnoreField.class)).map(it -> "*").toArray(String[]::new));
    }

    @SuppressFBWarnings(justification="generated code")
    public ControllerMethodDescriptor(@NonNull Method method, @NonNull Object[] patternArguments, @NonNull MessageWrapper wrapper) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (patternArguments == null) {
            throw new NullPointerException("patternArguments is marked non-null but is null");
        }
        if (wrapper == null) {
            throw new NullPointerException("wrapper is marked non-null but is null");
        }
        this.method = method;
        this.patternArguments = patternArguments;
        this.wrapper = wrapper;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public Method getMethod() {
        return this.method;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public Object[] getPatternArguments() {
        return this.patternArguments;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public MessageWrapper getWrapper() {
        return this.wrapper;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ControllerMethodDescriptor(method=" + this.getMethod() + ", patternArguments=" + Arrays.deepToString(this.getPatternArguments()) + ", wrapper=" + (Object)((Object)this.getWrapper()) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControllerMethodDescriptor)) {
            return false;
        }
        ControllerMethodDescriptor other = (ControllerMethodDescriptor)o;
        if (!Arrays.deepEquals(this.getPatternArguments(), other.getPatternArguments())) {
            return false;
        }
        MessageWrapper this$wrapper = this.getWrapper();
        MessageWrapper other$wrapper = other.getWrapper();
        return !(this$wrapper == null ? other$wrapper != null : !((Object)((Object)this$wrapper)).equals((Object)other$wrapper));
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getPatternArguments());
        MessageWrapper $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : ((Object)((Object)$wrapper)).hashCode());
        return result;
    }
}

