/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.Node;
import io.appulse.encon.Nodes;
import io.appulse.encon.handler.mailbox.DefaultMailboxHandler;
import io.appulse.encon.handler.message.MessageHandler;
import io.appulse.encon.handler.message.matcher.MethodMatcherMessageHandler;
import io.appulse.encon.handler.message.matcher.MethodMatcherMessageHandlerBuilder;
import io.appulse.encon.mailbox.Mailbox;
import io.appulse.encon.spring.ControllerMethodDescriptor;
import io.appulse.encon.spring.ErlangMailbox;
import io.appulse.encon.spring.MatchingCaseMapping;
import io.appulse.utils.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

class BeanPostProcessorMailboxHandler
implements BeanPostProcessor,
Ordered {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(BeanPostProcessorMailboxHandler.class);
    @NonNull
    private final Nodes nodes;
    @NonNull
    private final Node defaultNode;

    public int getOrder() {
        return 300;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Optional annotation = AnnotationUtils.findAnnotation(bean.getClass(), ErlangMailbox.class);
        if (!annotation.isPresent()) {
            return bean;
        }
        Node node = annotation.map(ErlangMailbox::node).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).flatMap(arg_0 -> ((Nodes)this.nodes).node(arg_0)).orElse(this.defaultNode);
        Mailbox mailbox = annotation.map(ErlangMailbox::name).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).map(arg_0 -> ((Node)node).mailbox(arg_0)).filter(Objects::nonNull).orElseGet(() -> {
            Collection mailboxes = node.mailboxes().values();
            int allowedMAilboxCountForChoosingDefaultOne = 2;
            if (mailboxes.size() > 2) {
                throw new IllegalStateException("Too many mailboxes in node " + node.getDescriptor().getNodeName() + ". Can't choose default one");
            }
            return (Mailbox)mailboxes.iterator().next();
        });
        List<Method> methods = Stream.of(ReflectionUtils.getAllDeclaredMethods(bean.getClass())).filter(it -> it.isAnnotationPresent(MatchingCaseMapping.class)).collect(Collectors.toList());
        if (!methods.isEmpty()) {
            DefaultMailboxHandler.builder().mailbox(mailbox).messageHandler(this.createMessageHandler(bean, methods)).build().startExecutor();
        }
        return bean;
    }

    private MessageHandler createMessageHandler(Object object, List<Method> methodDescriptors) {
        MethodMatcherMessageHandlerBuilder result = MethodMatcherMessageHandler.builder();
        MethodMatcherMessageHandlerBuilder.WrapperContainerBuilder wrapped = result.wrap(object);
        methodDescriptors.stream().map(ControllerMethodDescriptor::of).forEach(it -> {
            MethodMatcherMessageHandlerBuilder.ConsumerWithException consumer = obj -> {
                Object[] objectArray;
                if (it.getMethod().getParameterCount() == 1) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = it.getPatternArguments()[0];
                } else {
                    objectArray = it.getPatternArguments();
                }
                Object[] args = objectArray;
                ReflectionUtils.invokeMethod((Method)it.getMethod(), (Object)obj, (Object[])args);
            };
            switch (it.getWrapper()) {
                case TUPLE: {
                    wrapped.tuple(consumer);
                    break;
                }
                case LIST: {
                    wrapped.list(consumer);
                    break;
                }
                default: {
                    wrapped.none(consumer);
                }
            }
        });
        MethodMatcherMessageHandler messageHandler = result.build();
        log.debug("message handler map\n  {}", (Object)messageHandler.getMap());
        return messageHandler;
    }

    @SuppressFBWarnings(justification="generated code")
    public BeanPostProcessorMailboxHandler(@NonNull Nodes nodes, @NonNull Node defaultNode) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        if (defaultNode == null) {
            throw new NullPointerException("defaultNode is marked non-null but is null");
        }
        this.nodes = nodes;
        this.defaultNode = defaultNode;
    }
}

