/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.Node;
import io.appulse.encon.Nodes;
import io.appulse.encon.spring.ErlangMailbox;
import io.appulse.encon.spring.InjectMailbox;
import io.appulse.encon.spring.MailboxOperations;
import io.appulse.utils.AnnotationUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;

class BeanPostProcessorInjectMailboxAnnotation
implements BeanPostProcessor,
Ordered {
    @NonNull
    private final Nodes nodes;
    @NonNull
    private final Node defaultNode;
    @Autowired
    private final AbstractApplicationContext context;

    public int getOrder() {
        return 200;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Optional annotation = AnnotationUtils.findAnnotation(bean.getClass(), ErlangMailbox.class);
        if (!annotation.isPresent()) {
            return bean;
        }
        Field[] fields = (Field[])Stream.of(bean.getClass().getDeclaredFields()).filter(it -> it.isAnnotationPresent(InjectMailbox.class)).peek(it -> {
            if (!it.getType().equals(MailboxOperations.class)) {
                throw new IllegalStateException("Don't put @InjectRandomInt above " + it.getType());
            }
        }).peek(it -> {
            if (Modifier.isFinal(it.getModifiers())) {
                throw new IllegalStateException("Can't inject to final fields");
            }
        }).toArray(Field[]::new);
        if (fields.length == 0) {
            return bean;
        }
        Node node = annotation.map(ErlangMailbox::node).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).flatMap(arg_0 -> ((Nodes)this.nodes).node(arg_0)).orElse(this.defaultNode);
        Object mailboxOperations = annotation.map(ErlangMailbox::name).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).map(arg_0 -> ((Node)node).mailbox(arg_0)).filter(Objects::nonNull).map(MailboxOperations::generateName).map(arg_0 -> ((AbstractApplicationContext)this.context).getBean(arg_0)).orElseGet(() -> {
            String name = MailboxOperations.generateName(node);
            return this.context.getBean(name);
        });
        for (Field field : fields) {
            AccessController.doPrivileged(() -> {
                field.setAccessible(true);
                return null;
            });
            field.set(bean, mailboxOperations);
        }
        return bean;
    }

    @SuppressFBWarnings(justification="generated code")
    public BeanPostProcessorInjectMailboxAnnotation(@NonNull Nodes nodes, @NonNull Node defaultNode, AbstractApplicationContext context) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        if (defaultNode == null) {
            throw new NullPointerException("defaultNode is marked non-null but is null");
        }
        this.nodes = nodes;
        this.defaultNode = defaultNode;
        this.context = context;
    }
}

