/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import io.appulse.encon.common.DistributionFlag;
import io.appulse.encon.config.CompressionConfig;
import io.appulse.encon.config.Defaults;
import io.appulse.encon.config.MailboxConfig;
import io.appulse.encon.config.ServerConfig;
import io.appulse.epmd.java.core.model.NodeType;
import io.appulse.epmd.java.core.model.Protocol;
import io.appulse.epmd.java.core.model.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class NodeConfig {
    public static final NodeConfig DEFAULT = NodeConfig.builder().build();
    private Integer epmdPort;
    private NodeType type;
    private Boolean shortName;
    private String cookie;
    private Protocol protocol;
    private Version lowVersion;
    private Version highVersion;
    private Set<DistributionFlag> distributionFlags;
    private List<MailboxConfig> mailboxes;
    private ServerConfig server;
    private CompressionConfig compression;

    static NodeConfig newInstance(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        NodeConfigBuilder builder = NodeConfig.builder();
        Optional.ofNullable(map.get("epmd-port")).map(Object::toString).map(Integer::parseInt).ifPresent(builder::epmdPort);
        Optional.ofNullable(map.get("type")).map(Object::toString).map(NodeType::valueOf).ifPresent(builder::type);
        Optional.ofNullable(map.get("short-name")).map(Object::toString).map(Boolean::valueOf).ifPresent(builder::shortName);
        Optional.ofNullable(map.get("cookie")).map(Object::toString).ifPresent(builder::cookie);
        Optional.ofNullable(map.get("protocol")).map(Object::toString).map(Protocol::valueOf).ifPresent(builder::protocol);
        Optional.ofNullable(map.get("low-version")).map(Object::toString).map(Version::valueOf).ifPresent(builder::lowVersion);
        Optional.ofNullable(map.get("high-version")).map(Object::toString).map(Version::valueOf).ifPresent(builder::highVersion);
        Optional.ofNullable(map.get("distribution-flags")).filter(it -> it instanceof List).map(it -> (List)it).map(it -> it.stream().map(DistributionFlag::valueOf).collect(Collectors.toSet())).ifPresent(builder::distributionFlags);
        Optional.ofNullable(map.get("mailboxes")).filter(it -> it instanceof List).map(it -> (List)it).map(it -> it.stream().map(sub -> MailboxConfig.newInstance(sub)).collect(Collectors.toList())).ifPresent(builder::mailboxes);
        Optional.ofNullable(map.get("server")).filter(it -> it instanceof Map).map(it -> (Map)it).map(ServerConfig::newInstance).ifPresent(builder::server);
        Optional.ofNullable(map.get("compression")).filter(it -> it instanceof Map).map(it -> (Map)it).map(CompressionConfig::newInstance).ifPresent(builder::compression);
        return builder.build();
    }

    public NodeConfig(NodeConfig nodeConfig) {
        this.epmdPort = nodeConfig.getEpmdPort();
        this.type = nodeConfig.getType();
        this.shortName = nodeConfig.getShortName();
        this.cookie = nodeConfig.getCookie();
        this.protocol = nodeConfig.getProtocol();
        this.lowVersion = nodeConfig.getLowVersion();
        this.highVersion = nodeConfig.getHighVersion();
        this.distributionFlags = Optional.ofNullable(nodeConfig.getDistributionFlags()).map(HashSet::new).orElse(null);
        this.mailboxes = Optional.ofNullable(nodeConfig.getMailboxes()).map(it -> it.stream().map(MailboxConfig::new).collect(Collectors.toList())).orElse(null);
        this.server = Optional.ofNullable(nodeConfig.getServer()).map(ServerConfig::new).orElse(null);
        this.compression = Optional.ofNullable(nodeConfig.getCompression()).map(CompressionConfig::new).orElse(null);
    }

    public NodeConfig withDefaultsFrom(@NonNull Defaults defaults) {
        if (defaults == null) {
            throw new NullPointerException("defaults is marked @NonNull but is null");
        }
        this.epmdPort = Optional.ofNullable(this.epmdPort).orElse(defaults.getEpmdPort());
        this.type = Optional.ofNullable(this.type).orElse(defaults.getType());
        this.shortName = Optional.ofNullable(this.shortName).orElse(defaults.getShortName());
        this.cookie = Optional.ofNullable(this.cookie).orElse(defaults.getCookie());
        this.protocol = Optional.ofNullable(this.protocol).orElse(defaults.getProtocol());
        this.lowVersion = Optional.ofNullable(this.lowVersion).orElse(defaults.getLowVersion());
        this.highVersion = Optional.ofNullable(this.highVersion).orElse(defaults.getHighVersion());
        this.distributionFlags = Optional.ofNullable(this.distributionFlags).filter(it -> !it.isEmpty()).orElse(defaults.getDistributionFlags());
        this.mailboxes = Optional.ofNullable(this.mailboxes).map(it -> it.stream().map(mailbox -> mailbox.withDefaultsFrom(defaults.getMailbox())).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.server = Optional.ofNullable(this.server).orElse(ServerConfig.builder().build()).withDefaultsFrom(defaults.getServer());
        this.compression = Optional.ofNullable(this.compression).orElse(CompressionConfig.builder().build()).withDefaultsFrom(defaults.getCompression());
        return this;
    }

    public static NodeConfigBuilder builder() {
        return new NodeConfigBuilder();
    }

    public Integer getEpmdPort() {
        return this.epmdPort;
    }

    public NodeType getType() {
        return this.type;
    }

    public Boolean getShortName() {
        return this.shortName;
    }

    public String getCookie() {
        return this.cookie;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Version getLowVersion() {
        return this.lowVersion;
    }

    public Version getHighVersion() {
        return this.highVersion;
    }

    public Set<DistributionFlag> getDistributionFlags() {
        return this.distributionFlags;
    }

    public List<MailboxConfig> getMailboxes() {
        return this.mailboxes;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public CompressionConfig getCompression() {
        return this.compression;
    }

    public void setEpmdPort(Integer epmdPort) {
        this.epmdPort = epmdPort;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public void setShortName(Boolean shortName) {
        this.shortName = shortName;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setLowVersion(Version lowVersion) {
        this.lowVersion = lowVersion;
    }

    public void setHighVersion(Version highVersion) {
        this.highVersion = highVersion;
    }

    public void setDistributionFlags(Set<DistributionFlag> distributionFlags) {
        this.distributionFlags = distributionFlags;
    }

    public void setMailboxes(List<MailboxConfig> mailboxes) {
        this.mailboxes = mailboxes;
    }

    public void setServer(ServerConfig server) {
        this.server = server;
    }

    public void setCompression(CompressionConfig compression) {
        this.compression = compression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeConfig)) {
            return false;
        }
        NodeConfig other = (NodeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$epmdPort = this.getEpmdPort();
        Integer other$epmdPort = other.getEpmdPort();
        if (this$epmdPort == null ? other$epmdPort != null : !((Object)this$epmdPort).equals(other$epmdPort)) {
            return false;
        }
        NodeType this$type = this.getType();
        NodeType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Boolean this$shortName = this.getShortName();
        Boolean other$shortName = other.getShortName();
        if (this$shortName == null ? other$shortName != null : !((Object)this$shortName).equals(other$shortName)) {
            return false;
        }
        String this$cookie = this.getCookie();
        String other$cookie = other.getCookie();
        if (this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Version this$lowVersion = this.getLowVersion();
        Version other$lowVersion = other.getLowVersion();
        if (this$lowVersion == null ? other$lowVersion != null : !this$lowVersion.equals(other$lowVersion)) {
            return false;
        }
        Version this$highVersion = this.getHighVersion();
        Version other$highVersion = other.getHighVersion();
        if (this$highVersion == null ? other$highVersion != null : !this$highVersion.equals(other$highVersion)) {
            return false;
        }
        Set<DistributionFlag> this$distributionFlags = this.getDistributionFlags();
        Set<DistributionFlag> other$distributionFlags = other.getDistributionFlags();
        if (this$distributionFlags == null ? other$distributionFlags != null : !((Object)this$distributionFlags).equals(other$distributionFlags)) {
            return false;
        }
        List<MailboxConfig> this$mailboxes = this.getMailboxes();
        List<MailboxConfig> other$mailboxes = other.getMailboxes();
        if (this$mailboxes == null ? other$mailboxes != null : !((Object)this$mailboxes).equals(other$mailboxes)) {
            return false;
        }
        ServerConfig this$server = this.getServer();
        ServerConfig other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        CompressionConfig this$compression = this.getCompression();
        CompressionConfig other$compression = other.getCompression();
        return !(this$compression == null ? other$compression != null : !((Object)this$compression).equals(other$compression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $epmdPort = this.getEpmdPort();
        result = result * 59 + ($epmdPort == null ? 43 : ((Object)$epmdPort).hashCode());
        NodeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Boolean $shortName = this.getShortName();
        result = result * 59 + ($shortName == null ? 43 : ((Object)$shortName).hashCode());
        String $cookie = this.getCookie();
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Version $lowVersion = this.getLowVersion();
        result = result * 59 + ($lowVersion == null ? 43 : $lowVersion.hashCode());
        Version $highVersion = this.getHighVersion();
        result = result * 59 + ($highVersion == null ? 43 : $highVersion.hashCode());
        Set<DistributionFlag> $distributionFlags = this.getDistributionFlags();
        result = result * 59 + ($distributionFlags == null ? 43 : ((Object)$distributionFlags).hashCode());
        List<MailboxConfig> $mailboxes = this.getMailboxes();
        result = result * 59 + ($mailboxes == null ? 43 : ((Object)$mailboxes).hashCode());
        ServerConfig $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        CompressionConfig $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : ((Object)$compression).hashCode());
        return result;
    }

    public String toString() {
        return "NodeConfig(epmdPort=" + this.getEpmdPort() + ", type=" + this.getType() + ", shortName=" + this.getShortName() + ", cookie=" + this.getCookie() + ", protocol=" + this.getProtocol() + ", lowVersion=" + this.getLowVersion() + ", highVersion=" + this.getHighVersion() + ", distributionFlags=" + this.getDistributionFlags() + ", mailboxes=" + this.getMailboxes() + ", server=" + this.getServer() + ", compression=" + this.getCompression() + ")";
    }

    public NodeConfig() {
    }

    public NodeConfig(Integer epmdPort, NodeType type, Boolean shortName, String cookie, Protocol protocol, Version lowVersion, Version highVersion, Set<DistributionFlag> distributionFlags, List<MailboxConfig> mailboxes, ServerConfig server, CompressionConfig compression) {
        this.epmdPort = epmdPort;
        this.type = type;
        this.shortName = shortName;
        this.cookie = cookie;
        this.protocol = protocol;
        this.lowVersion = lowVersion;
        this.highVersion = highVersion;
        this.distributionFlags = distributionFlags;
        this.mailboxes = mailboxes;
        this.server = server;
        this.compression = compression;
    }

    public static class NodeConfigBuilder {
        private Integer epmdPort;
        private NodeType type;
        private Boolean shortName;
        private String cookie;
        private Protocol protocol;
        private Version lowVersion;
        private Version highVersion;
        private ArrayList<DistributionFlag> distributionFlags;
        private ArrayList<MailboxConfig> mailboxes;
        private ServerConfig server;
        private CompressionConfig compression;

        NodeConfigBuilder() {
        }

        public NodeConfigBuilder epmdPort(Integer epmdPort) {
            this.epmdPort = epmdPort;
            return this;
        }

        public NodeConfigBuilder type(NodeType type) {
            this.type = type;
            return this;
        }

        public NodeConfigBuilder shortName(Boolean shortName) {
            this.shortName = shortName;
            return this;
        }

        public NodeConfigBuilder cookie(String cookie) {
            this.cookie = cookie;
            return this;
        }

        public NodeConfigBuilder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public NodeConfigBuilder lowVersion(Version lowVersion) {
            this.lowVersion = lowVersion;
            return this;
        }

        public NodeConfigBuilder highVersion(Version highVersion) {
            this.highVersion = highVersion;
            return this;
        }

        public NodeConfigBuilder distributionFlag(DistributionFlag distributionFlag) {
            if (this.distributionFlags == null) {
                this.distributionFlags = new ArrayList();
            }
            this.distributionFlags.add(distributionFlag);
            return this;
        }

        public NodeConfigBuilder distributionFlags(Collection<? extends DistributionFlag> distributionFlags) {
            if (this.distributionFlags == null) {
                this.distributionFlags = new ArrayList();
            }
            this.distributionFlags.addAll(distributionFlags);
            return this;
        }

        public NodeConfigBuilder clearDistributionFlags() {
            if (this.distributionFlags != null) {
                this.distributionFlags.clear();
            }
            return this;
        }

        public NodeConfigBuilder mailbox(MailboxConfig mailbox) {
            if (this.mailboxes == null) {
                this.mailboxes = new ArrayList();
            }
            this.mailboxes.add(mailbox);
            return this;
        }

        public NodeConfigBuilder mailboxes(Collection<? extends MailboxConfig> mailboxes) {
            if (this.mailboxes == null) {
                this.mailboxes = new ArrayList();
            }
            this.mailboxes.addAll(mailboxes);
            return this;
        }

        public NodeConfigBuilder clearMailboxes() {
            if (this.mailboxes != null) {
                this.mailboxes.clear();
            }
            return this;
        }

        public NodeConfigBuilder server(ServerConfig server) {
            this.server = server;
            return this;
        }

        public NodeConfigBuilder compression(CompressionConfig compression) {
            this.compression = compression;
            return this;
        }

        public NodeConfig build() {
            List<MailboxConfig> mailboxes;
            Set<Object> distributionFlags;
            switch (this.distributionFlags == null ? 0 : this.distributionFlags.size()) {
                case 0: {
                    distributionFlags = Collections.emptySet();
                    break;
                }
                case 1: {
                    distributionFlags = Collections.singleton(this.distributionFlags.get(0));
                    break;
                }
                default: {
                    distributionFlags = new LinkedHashSet(this.distributionFlags.size() < 0x40000000 ? 1 + this.distributionFlags.size() + (this.distributionFlags.size() - 3) / 3 : Integer.MAX_VALUE);
                    distributionFlags.addAll(this.distributionFlags);
                    distributionFlags = Collections.unmodifiableSet(distributionFlags);
                }
            }
            switch (this.mailboxes == null ? 0 : this.mailboxes.size()) {
                case 0: {
                    mailboxes = Collections.emptyList();
                    break;
                }
                case 1: {
                    mailboxes = Collections.singletonList(this.mailboxes.get(0));
                    break;
                }
                default: {
                    mailboxes = Collections.unmodifiableList(new ArrayList<MailboxConfig>(this.mailboxes));
                }
            }
            return new NodeConfig(this.epmdPort, this.type, this.shortName, this.cookie, this.protocol, this.lowVersion, this.highVersion, distributionFlags, mailboxes, this.server, this.compression);
        }

        public String toString() {
            return "NodeConfig.NodeConfigBuilder(epmdPort=" + this.epmdPort + ", type=" + this.type + ", shortName=" + this.shortName + ", cookie=" + this.cookie + ", protocol=" + this.protocol + ", lowVersion=" + this.lowVersion + ", highVersion=" + this.highVersion + ", distributionFlags=" + this.distributionFlags + ", mailboxes=" + this.mailboxes + ", server=" + this.server + ", compression=" + this.compression + ")";
        }
    }
}

