/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class CompressionConfig {
    private Boolean enabled;
    private Integer level;

    static CompressionConfig newInstance(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked @NonNull but is null");
        }
        CompressionConfigBuilder builder = CompressionConfig.builder();
        Optional.ofNullable(map.get("enabled")).map(Object::toString).map(Boolean::parseBoolean).ifPresent(builder::enabled);
        Optional.ofNullable(map.get("level")).map(Object::toString).map(Integer::parseInt).ifPresent(builder::level);
        return builder.build();
    }

    public CompressionConfig(CompressionConfig compressionConfig) {
        this.enabled = compressionConfig.getEnabled();
        this.level = compressionConfig.getLevel();
    }

    CompressionConfig withDefaultsFrom(@NonNull CompressionConfig defaults) {
        if (defaults == null) {
            throw new NullPointerException("defaults is marked @NonNull but is null");
        }
        this.enabled = Optional.ofNullable(this.enabled).orElse(defaults.getEnabled());
        this.level = Optional.ofNullable(this.level).orElse(defaults.getLevel());
        return this;
    }

    public static CompressionConfigBuilder builder() {
        return new CompressionConfigBuilder();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompressionConfig)) {
            return false;
        }
        CompressionConfig other = (CompressionConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !((Object)this$level).equals(other$level));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompressionConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        return result;
    }

    public String toString() {
        return "CompressionConfig(enabled=" + this.getEnabled() + ", level=" + this.getLevel() + ")";
    }

    public CompressionConfig() {
    }

    public CompressionConfig(Boolean enabled, Integer level) {
        this.enabled = enabled;
        this.level = level;
    }

    public static class CompressionConfigBuilder {
        private Boolean enabled;
        private Integer level;

        CompressionConfigBuilder() {
        }

        public CompressionConfigBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public CompressionConfigBuilder level(Integer level) {
            this.level = level;
            return this;
        }

        public CompressionConfig build() {
            return new CompressionConfig(this.enabled, this.level);
        }

        public String toString() {
            return "CompressionConfig.CompressionConfigBuilder(enabled=" + this.enabled + ", level=" + this.level + ")";
        }
    }
}

