/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import io.appulse.encon.common.DistributionFlag;
import io.appulse.encon.config.CompressionConfig;
import io.appulse.encon.config.MailboxConfig;
import io.appulse.encon.config.ServerConfig;
import io.appulse.epmd.java.client.EpmdDefaults;
import io.appulse.epmd.java.core.model.NodeType;
import io.appulse.epmd.java.core.model.Protocol;
import io.appulse.epmd.java.core.model.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Defaults {
    public static final Defaults INSTANCE = Defaults.builder().build();
    private int epmdPort;
    private NodeType type;
    private Boolean shortName;
    private String cookie;
    private Protocol protocol;
    private Version lowVersion;
    private Version highVersion;
    private Set<DistributionFlag> distributionFlags;
    private MailboxConfig mailbox;
    private ServerConfig server;
    private CompressionConfig compression;

    public static String getDefaultCookie() {
        Path cookieFile = Paths.get(Defaults.getHomeDir(), ".erlang.cookie");
        if (!Files.exists(cookieFile, new LinkOption[0])) {
            return "";
        }
        try {
            return Files.lines(cookieFile).filter(Objects::nonNull).map(String::trim).filter(it -> !it.isEmpty()).findFirst().orElse("");
        }
        catch (IOException ex) {
            return "";
        }
    }

    public static String getHomeDir() {
        String home = System.getProperty("user.home");
        if (!System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
            return home;
        }
        String drive = System.getenv("HOMEDRIVE");
        String path = System.getenv("HOMEPATH");
        return drive == null || path == null ? home : drive + path;
    }

    static Defaults newInstance(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        DefaultsBuilder builder = Defaults.builder();
        Optional.ofNullable(map.get("epmd-port")).map(Object::toString).map(Integer::parseInt).ifPresent(builder::epmdPort);
        Optional.ofNullable(map.get("type")).map(Object::toString).map(NodeType::valueOf).ifPresent(builder::type);
        Optional.ofNullable(map.get("short-name")).map(Object::toString).map(Boolean::valueOf).ifPresent(builder::shortName);
        Optional.ofNullable(map.get("cookie")).map(Object::toString).ifPresent(builder::cookie);
        Optional.ofNullable(map.get("protocol")).map(Object::toString).map(Protocol::valueOf).ifPresent(builder::protocol);
        Optional.ofNullable(map.get("low-version")).map(Object::toString).map(Version::valueOf).ifPresent(builder::lowVersion);
        Optional.ofNullable(map.get("high-version")).map(Object::toString).map(Version::valueOf).ifPresent(builder::highVersion);
        Optional.ofNullable(map.get("distribution-flags")).filter(it -> it instanceof List).map(it -> (List)it).map(it -> it.stream().map(DistributionFlag::valueOf).collect(Collectors.toSet())).ifPresent(builder::distributionFlags);
        Optional.ofNullable(map.get("mailbox")).filter(it -> it instanceof Map).map(it -> (Map)it).map(MailboxConfig::newInstance).ifPresent(builder::mailbox);
        Optional.ofNullable(map.get("server")).filter(it -> it instanceof Map).map(it -> (Map)it).map(ServerConfig::newInstance).ifPresent(builder::server);
        Optional.ofNullable(map.get("compression")).filter(it -> it instanceof Map).map(it -> (Map)it).map(CompressionConfig::newInstance).ifPresent(builder::compression);
        return builder.build();
    }

    public Defaults(Defaults defaults) {
        this.epmdPort = defaults.getEpmdPort();
        this.type = defaults.getType();
        this.shortName = defaults.getShortName();
        this.cookie = defaults.getCookie();
        this.protocol = defaults.getProtocol();
        this.lowVersion = defaults.getLowVersion();
        this.highVersion = defaults.getHighVersion();
        this.distributionFlags = Optional.ofNullable(defaults.getDistributionFlags()).map(HashSet::new).orElse(null);
        this.mailbox = Optional.ofNullable(defaults.getMailbox()).map(MailboxConfig::new).orElse(null);
        this.server = Optional.ofNullable(defaults.getServer()).map(ServerConfig::new).orElse(null);
        this.compression = Optional.ofNullable(defaults.getCompression()).map(CompressionConfig::new).orElse(null);
    }

    private static int $default$epmdPort() {
        return EpmdDefaults.PORT;
    }

    private static NodeType $default$type() {
        return NodeType.R6_ERLANG;
    }

    private static Boolean $default$shortName() {
        return Boolean.FALSE;
    }

    private static String $default$cookie() {
        return Defaults.getDefaultCookie();
    }

    private static Protocol $default$protocol() {
        return Protocol.TCP;
    }

    private static Version $default$lowVersion() {
        return Version.R6;
    }

    private static Version $default$highVersion() {
        return Version.R6;
    }

    private static Set<DistributionFlag> $default$distributionFlags() {
        return new HashSet<DistributionFlag>(Arrays.asList(DistributionFlag.EXTENDED_REFERENCES, DistributionFlag.EXTENDED_PIDS_PORTS, DistributionFlag.BIT_BINARIES, DistributionFlag.NEW_FLOATS, DistributionFlag.FUN_TAGS, DistributionFlag.NEW_FUN_TAGS, DistributionFlag.UTF8_ATOMS, DistributionFlag.MAP_TAG, DistributionFlag.BIG_CREATION));
    }

    private static MailboxConfig $default$mailbox() {
        return MailboxConfig.builder().build();
    }

    private static ServerConfig $default$server() {
        return ServerConfig.builder().bossThreads(1).workerThreads(2).build();
    }

    private static CompressionConfig $default$compression() {
        return CompressionConfig.builder().enabled(Boolean.FALSE).level(-1).build();
    }

    public static DefaultsBuilder builder() {
        return new DefaultsBuilder();
    }

    public int getEpmdPort() {
        return this.epmdPort;
    }

    public NodeType getType() {
        return this.type;
    }

    public Boolean getShortName() {
        return this.shortName;
    }

    public String getCookie() {
        return this.cookie;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Version getLowVersion() {
        return this.lowVersion;
    }

    public Version getHighVersion() {
        return this.highVersion;
    }

    public Set<DistributionFlag> getDistributionFlags() {
        return this.distributionFlags;
    }

    public MailboxConfig getMailbox() {
        return this.mailbox;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public CompressionConfig getCompression() {
        return this.compression;
    }

    public void setEpmdPort(int epmdPort) {
        this.epmdPort = epmdPort;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public void setShortName(Boolean shortName) {
        this.shortName = shortName;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setLowVersion(Version lowVersion) {
        this.lowVersion = lowVersion;
    }

    public void setHighVersion(Version highVersion) {
        this.highVersion = highVersion;
    }

    public void setDistributionFlags(Set<DistributionFlag> distributionFlags) {
        this.distributionFlags = distributionFlags;
    }

    public void setMailbox(MailboxConfig mailbox) {
        this.mailbox = mailbox;
    }

    public void setServer(ServerConfig server) {
        this.server = server;
    }

    public void setCompression(CompressionConfig compression) {
        this.compression = compression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Defaults)) {
            return false;
        }
        Defaults other = (Defaults)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpmdPort() != other.getEpmdPort()) {
            return false;
        }
        NodeType this$type = this.getType();
        NodeType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Boolean this$shortName = this.getShortName();
        Boolean other$shortName = other.getShortName();
        if (this$shortName == null ? other$shortName != null : !((Object)this$shortName).equals(other$shortName)) {
            return false;
        }
        String this$cookie = this.getCookie();
        String other$cookie = other.getCookie();
        if (this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Version this$lowVersion = this.getLowVersion();
        Version other$lowVersion = other.getLowVersion();
        if (this$lowVersion == null ? other$lowVersion != null : !this$lowVersion.equals(other$lowVersion)) {
            return false;
        }
        Version this$highVersion = this.getHighVersion();
        Version other$highVersion = other.getHighVersion();
        if (this$highVersion == null ? other$highVersion != null : !this$highVersion.equals(other$highVersion)) {
            return false;
        }
        Set<DistributionFlag> this$distributionFlags = this.getDistributionFlags();
        Set<DistributionFlag> other$distributionFlags = other.getDistributionFlags();
        if (this$distributionFlags == null ? other$distributionFlags != null : !((Object)this$distributionFlags).equals(other$distributionFlags)) {
            return false;
        }
        MailboxConfig this$mailbox = this.getMailbox();
        MailboxConfig other$mailbox = other.getMailbox();
        if (this$mailbox == null ? other$mailbox != null : !((Object)this$mailbox).equals(other$mailbox)) {
            return false;
        }
        ServerConfig this$server = this.getServer();
        ServerConfig other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        CompressionConfig this$compression = this.getCompression();
        CompressionConfig other$compression = other.getCompression();
        return !(this$compression == null ? other$compression != null : !((Object)this$compression).equals(other$compression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Defaults;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEpmdPort();
        NodeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Boolean $shortName = this.getShortName();
        result = result * 59 + ($shortName == null ? 43 : ((Object)$shortName).hashCode());
        String $cookie = this.getCookie();
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Version $lowVersion = this.getLowVersion();
        result = result * 59 + ($lowVersion == null ? 43 : $lowVersion.hashCode());
        Version $highVersion = this.getHighVersion();
        result = result * 59 + ($highVersion == null ? 43 : $highVersion.hashCode());
        Set<DistributionFlag> $distributionFlags = this.getDistributionFlags();
        result = result * 59 + ($distributionFlags == null ? 43 : ((Object)$distributionFlags).hashCode());
        MailboxConfig $mailbox = this.getMailbox();
        result = result * 59 + ($mailbox == null ? 43 : ((Object)$mailbox).hashCode());
        ServerConfig $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        CompressionConfig $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : ((Object)$compression).hashCode());
        return result;
    }

    public String toString() {
        return "Defaults(epmdPort=" + this.getEpmdPort() + ", type=" + this.getType() + ", shortName=" + this.getShortName() + ", cookie=" + this.getCookie() + ", protocol=" + this.getProtocol() + ", lowVersion=" + this.getLowVersion() + ", highVersion=" + this.getHighVersion() + ", distributionFlags=" + this.getDistributionFlags() + ", mailbox=" + this.getMailbox() + ", server=" + this.getServer() + ", compression=" + this.getCompression() + ")";
    }

    public Defaults() {
        this.epmdPort = Defaults.$default$epmdPort();
        this.type = Defaults.$default$type();
        this.shortName = Defaults.$default$shortName();
        this.cookie = Defaults.$default$cookie();
        this.protocol = Defaults.$default$protocol();
        this.lowVersion = Defaults.$default$lowVersion();
        this.highVersion = Defaults.$default$highVersion();
        this.distributionFlags = Defaults.$default$distributionFlags();
        this.mailbox = Defaults.$default$mailbox();
        this.server = Defaults.$default$server();
        this.compression = Defaults.$default$compression();
    }

    public Defaults(int epmdPort, NodeType type, Boolean shortName, String cookie, Protocol protocol, Version lowVersion, Version highVersion, Set<DistributionFlag> distributionFlags, MailboxConfig mailbox, ServerConfig server, CompressionConfig compression) {
        this.epmdPort = epmdPort;
        this.type = type;
        this.shortName = shortName;
        this.cookie = cookie;
        this.protocol = protocol;
        this.lowVersion = lowVersion;
        this.highVersion = highVersion;
        this.distributionFlags = distributionFlags;
        this.mailbox = mailbox;
        this.server = server;
        this.compression = compression;
    }

    public static class DefaultsBuilder {
        private boolean epmdPort$set;
        private int epmdPort$value;
        private boolean type$set;
        private NodeType type$value;
        private boolean shortName$set;
        private Boolean shortName$value;
        private boolean cookie$set;
        private String cookie$value;
        private boolean protocol$set;
        private Protocol protocol$value;
        private boolean lowVersion$set;
        private Version lowVersion$value;
        private boolean highVersion$set;
        private Version highVersion$value;
        private boolean distributionFlags$set;
        private Set<DistributionFlag> distributionFlags$value;
        private boolean mailbox$set;
        private MailboxConfig mailbox$value;
        private boolean server$set;
        private ServerConfig server$value;
        private boolean compression$set;
        private CompressionConfig compression$value;

        DefaultsBuilder() {
        }

        public DefaultsBuilder epmdPort(int epmdPort) {
            this.epmdPort$value = epmdPort;
            this.epmdPort$set = true;
            return this;
        }

        public DefaultsBuilder type(NodeType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public DefaultsBuilder shortName(Boolean shortName) {
            this.shortName$value = shortName;
            this.shortName$set = true;
            return this;
        }

        public DefaultsBuilder cookie(String cookie) {
            this.cookie$value = cookie;
            this.cookie$set = true;
            return this;
        }

        public DefaultsBuilder protocol(Protocol protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        public DefaultsBuilder lowVersion(Version lowVersion) {
            this.lowVersion$value = lowVersion;
            this.lowVersion$set = true;
            return this;
        }

        public DefaultsBuilder highVersion(Version highVersion) {
            this.highVersion$value = highVersion;
            this.highVersion$set = true;
            return this;
        }

        public DefaultsBuilder distributionFlags(Set<DistributionFlag> distributionFlags) {
            this.distributionFlags$value = distributionFlags;
            this.distributionFlags$set = true;
            return this;
        }

        public DefaultsBuilder mailbox(MailboxConfig mailbox) {
            this.mailbox$value = mailbox;
            this.mailbox$set = true;
            return this;
        }

        public DefaultsBuilder server(ServerConfig server) {
            this.server$value = server;
            this.server$set = true;
            return this;
        }

        public DefaultsBuilder compression(CompressionConfig compression) {
            this.compression$value = compression;
            this.compression$set = true;
            return this;
        }

        public Defaults build() {
            int epmdPort$value = this.epmdPort$value;
            if (!this.epmdPort$set) {
                epmdPort$value = Defaults.$default$epmdPort();
            }
            NodeType type$value = this.type$value;
            if (!this.type$set) {
                type$value = Defaults.$default$type();
            }
            Boolean shortName$value = this.shortName$value;
            if (!this.shortName$set) {
                shortName$value = Defaults.$default$shortName();
            }
            String cookie$value = this.cookie$value;
            if (!this.cookie$set) {
                cookie$value = Defaults.$default$cookie();
            }
            Protocol protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = Defaults.$default$protocol();
            }
            Version lowVersion$value = this.lowVersion$value;
            if (!this.lowVersion$set) {
                lowVersion$value = Defaults.$default$lowVersion();
            }
            Version highVersion$value = this.highVersion$value;
            if (!this.highVersion$set) {
                highVersion$value = Defaults.$default$highVersion();
            }
            Set distributionFlags$value = this.distributionFlags$value;
            if (!this.distributionFlags$set) {
                distributionFlags$value = Defaults.$default$distributionFlags();
            }
            MailboxConfig mailbox$value = this.mailbox$value;
            if (!this.mailbox$set) {
                mailbox$value = Defaults.$default$mailbox();
            }
            ServerConfig server$value = this.server$value;
            if (!this.server$set) {
                server$value = Defaults.$default$server();
            }
            CompressionConfig compression$value = this.compression$value;
            if (!this.compression$set) {
                compression$value = Defaults.$default$compression();
            }
            return new Defaults(epmdPort$value, type$value, shortName$value, cookie$value, protocol$value, lowVersion$value, highVersion$value, distributionFlags$value, mailbox$value, server$value, compression$value);
        }

        public String toString() {
            return "Defaults.DefaultsBuilder(epmdPort$value=" + this.epmdPort$value + ", type$value=" + this.type$value + ", shortName$value=" + this.shortName$value + ", cookie$value=" + this.cookie$value + ", protocol$value=" + this.protocol$value + ", lowVersion$value=" + this.lowVersion$value + ", highVersion$value=" + this.highVersion$value + ", distributionFlags$value=" + this.distributionFlags$value + ", mailbox$value=" + this.mailbox$value + ", server$value=" + this.server$value + ", compression$value=" + this.compression$value + ")";
        }
    }
}

