/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.encon.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.encon.config.Defaults;
import io.appulse.encon.config.NodeConfig;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.yaml.snakeyaml.Yaml;

@SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
public final class Config {
    Defaults defaults;
    Map<String, NodeConfig> nodes;

    public static Config load(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        File file = new File(fileName);
        return Config.load(file);
    }

    public static Config load(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        File file = path.toFile();
        return Config.load(file);
    }

    public static Config load(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Map<String, Map<String, Object>> map = Config.parseYaml(file);
        ConfigBuilder builder = Config.builder();
        Optional.ofNullable(map).map(it -> (Map)it.get("defaults")).filter(Objects::nonNull).map(Defaults::newInstance).ifPresent(builder::defaults);
        Optional.ofNullable(map).map(it -> (Map)it.get("nodes")).filter(Objects::nonNull).map(subMap -> subMap.entrySet().stream().filter(it -> it.getValue() instanceof Map).collect(Collectors.toMap(Map.Entry::getKey, it -> NodeConfig.newInstance((Map)it.getValue())))).ifPresent(builder::nodes);
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Map<String, Object>> parseYaml(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Yaml yaml = new Yaml();
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Map map = (Map)yaml.load(inputStream);
            return map;
        }
    }

    public Config(Config config) {
        this.defaults = Optional.ofNullable(config.getDefaults()).map(Defaults::new).orElse(null);
        this.nodes = Optional.ofNullable(config.getNodes()).map(it -> it.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), new NodeConfig((NodeConfig)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(null);
    }

    private Config(Defaults defaults, Map<String, NodeConfig> nodes) {
        this.defaults = Optional.ofNullable(defaults).orElse(Defaults.INSTANCE);
        this.nodes = nodes.entrySet().stream().peek(it -> ((NodeConfig)it.getValue()).withDefaultsFrom(this.defaults)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public Defaults getDefaults() {
        return this.defaults;
    }

    public Map<String, NodeConfig> getNodes() {
        return this.nodes;
    }

    public void setDefaults(Defaults defaults) {
        this.defaults = defaults;
    }

    public void setNodes(Map<String, NodeConfig> nodes) {
        this.nodes = nodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        Defaults this$defaults = this.getDefaults();
        Defaults other$defaults = other.getDefaults();
        if (this$defaults == null ? other$defaults != null : !((Object)this$defaults).equals(other$defaults)) {
            return false;
        }
        Map<String, NodeConfig> this$nodes = this.getNodes();
        Map<String, NodeConfig> other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Defaults $defaults = this.getDefaults();
        result = result * 59 + ($defaults == null ? 43 : ((Object)$defaults).hashCode());
        Map<String, NodeConfig> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        return result;
    }

    public String toString() {
        return "Config(defaults=" + this.getDefaults() + ", nodes=" + this.getNodes() + ")";
    }

    public Config() {
    }

    public static class ConfigBuilder {
        private Defaults defaults;
        private ArrayList<String> nodes$key;
        private ArrayList<NodeConfig> nodes$value;

        ConfigBuilder() {
        }

        public ConfigBuilder defaults(Defaults defaults) {
            this.defaults = defaults;
            return this;
        }

        public ConfigBuilder node(String nodeKey, NodeConfig nodeValue) {
            if (this.nodes$key == null) {
                this.nodes$key = new ArrayList();
                this.nodes$value = new ArrayList();
            }
            this.nodes$key.add(nodeKey);
            this.nodes$value.add(nodeValue);
            return this;
        }

        public ConfigBuilder nodes(Map<? extends String, ? extends NodeConfig> nodes) {
            if (nodes == null) {
                throw new NullPointerException("nodes cannot be null");
            }
            if (this.nodes$key == null) {
                this.nodes$key = new ArrayList();
                this.nodes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends NodeConfig> $lombokEntry : nodes.entrySet()) {
                this.nodes$key.add($lombokEntry.getKey());
                this.nodes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ConfigBuilder clearNodes() {
            if (this.nodes$key != null) {
                this.nodes$key.clear();
                this.nodes$value.clear();
            }
            return this;
        }

        public Config build() {
            Map<Object, Object> nodes;
            switch (this.nodes$key == null ? 0 : this.nodes$key.size()) {
                case 0: {
                    nodes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    nodes = Collections.singletonMap(this.nodes$key.get(0), this.nodes$value.get(0));
                    break;
                }
                default: {
                    nodes = new LinkedHashMap(this.nodes$key.size() < 0x40000000 ? 1 + this.nodes$key.size() + (this.nodes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.nodes$key.size(); ++$i) {
                        nodes.put(this.nodes$key.get($i), this.nodes$value.get($i));
                    }
                    nodes = Collections.unmodifiableMap(nodes);
                }
            }
            return new Config(this.defaults, nodes);
        }

        public String toString() {
            return "Config.ConfigBuilder(defaults=" + this.defaults + ", nodes$key=" + this.nodes$key + ", nodes$value=" + this.nodes$value + ")";
        }
    }
}

